/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.utils.diff;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.logging.Logger;
import one.tranic.t.utils.compress.ICompress;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class SimplePatcher {
    private static final int CHUNK_SIZE = 4096;
    private static final byte COMMAND_EQUAL = 0;
    private static final byte COMMAND_INSERT = 1;
    private static final byte COMMAND_DELETE = 2;

    public static OutputStream createPatch(InputStream newFile, InputStream oldFile) throws IOException {
        ByteArrayOutputStream patchOutputStream = new ByteArrayOutputStream();
        DataOutputStream patch = new DataOutputStream(patchOutputStream);
        byte[] srcData = SimplePatcher.readAllBytes(newFile);
        byte[] dstData = SimplePatcher.readAllBytes(oldFile);
        patch.writeInt(srcData.length);
        patch.writeInt(dstData.length);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] srcHash = md.digest(srcData);
            patch.write(srcHash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Failed to calculate MD5 checksum", e);
        }
        int i = 0;
        int j = 0;
        while (i < srcData.length || j < dstData.length) {
            int matchLength = 0;
            while (i + matchLength < srcData.length && j + matchLength < dstData.length && srcData[i + matchLength] == dstData[j + matchLength]) {
                ++matchLength;
            }
            if (matchLength > 0) {
                patch.writeByte(0);
                patch.writeInt(matchLength);
                i += matchLength;
                j += matchLength;
                continue;
            }
            int srcDiffStart = i;
            int dstDiffStart = j;
            do {
                int lookAhead;
                boolean foundMatch = false;
                for (lookAhead = 1; lookAhead < 32 && i + lookAhead < srcData.length && j < dstData.length; ++lookAhead) {
                    if (srcData[i + lookAhead] != dstData[j]) continue;
                    i += lookAhead;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) break;
                for (lookAhead = 1; lookAhead < 32 && i < srcData.length && j + lookAhead < dstData.length; ++lookAhead) {
                    if (srcData[i] != dstData[j + lookAhead]) continue;
                    j += lookAhead;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) break;
                if (i < srcData.length) {
                    ++i;
                }
                if (j >= dstData.length) continue;
                ++j;
            } while (i < srcData.length || j < dstData.length);
            if (i > srcDiffStart) {
                patch.writeByte(1);
                patch.writeInt(i - srcDiffStart);
                patch.write(srcData, srcDiffStart, i - srcDiffStart);
            }
            if (j <= dstDiffStart) continue;
            patch.writeByte(2);
            patch.writeInt(j - dstDiffStart);
            patch.write(dstData, dstDiffStart, j - dstDiffStart);
        }
        patch.flush();
        return patchOutputStream;
    }

    public static void createPatch(File newFile, File oldFile, File patchFile) throws IOException {
        SimplePatcher.createPatch(newFile, oldFile, patchFile, null);
    }

    public static void createPatch(File newFile, File oldFile, File patchFile, @Nullable ICompress compression) throws IOException {
        SimplePatcher.validatePatchFiles(newFile, oldFile, patchFile);
        try (FileInputStream newStream = new FileInputStream(newFile);
             FileInputStream oldStream = new FileInputStream(oldFile);
             FileOutputStream patchStream = new FileOutputStream(patchFile);){
            ByteArrayOutputStream patchData = (ByteArrayOutputStream)SimplePatcher.createPatch(newStream, oldStream);
            SimplePatcher.processPatchData(patchData, patchStream, compression, true);
        }
    }

    private static void writePatchData(ByteArrayOutputStream patchData, OutputStream outputStream, @Nullable ICompress compress) throws IOException {
        if (compress != null) {
            try (ByteArrayInputStream patchInputStream = new ByteArrayInputStream(patchData.toByteArray());){
                compress.compress(patchInputStream, outputStream);
            }
        } else {
            patchData.writeTo(outputStream);
        }
        outputStream.flush();
    }

    public static File createPatch(File newFile, File oldFile) throws IOException {
        File patchFile = File.createTempFile("diff", ".sdiff");
        try {
            SimplePatcher.createPatch(newFile, oldFile, patchFile);
            return patchFile;
        }
        catch (IOException e) {
            patchFile.delete();
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OutputStream applyPatch(InputStream patch, InputStream dst) throws IOException {
        DataInputStream patchInput = new DataInputStream(patch);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] dstData = SimplePatcher.readAllBytes(dst);
        int originalSrcSize = patchInput.readInt();
        int originalDstSize = patchInput.readInt();
        if (dstData.length != originalDstSize) {
            throw new IllegalStateException("Patch not applicable to target file: size mismatch, expected " + originalDstSize + ", actual " + dstData.length);
        }
        byte[] expectedMD5 = new byte[16];
        patchInput.readFully(expectedMD5);
        int dstPos = 0;
        try {
            block7: while (patchInput.available() > 0) {
                byte command = patchInput.readByte();
                switch (command) {
                    case 0: {
                        int equalLength = patchInput.readInt();
                        if (dstPos + equalLength > dstData.length) {
                            throw new IllegalStateException("Patch application failed: exceeded target file boundary");
                        }
                        output.write(dstData, dstPos, equalLength);
                        dstPos += equalLength;
                        continue block7;
                    }
                    case 1: {
                        int insertLength = patchInput.readInt();
                        byte[] insertData = new byte[insertLength];
                        patchInput.readFully(insertData);
                        output.write(insertData);
                        continue block7;
                    }
                    case 2: {
                        int deleteLength = patchInput.readInt();
                        byte[] expectedDeleteData = new byte[deleteLength];
                        patchInput.readFully(expectedDeleteData);
                        if (dstPos + deleteLength > dstData.length) {
                            throw new IllegalStateException("Patch application failed: exceeded target file boundary");
                        }
                        byte[] actualDeleteData = Arrays.copyOfRange(dstData, dstPos, dstPos + deleteLength);
                        if (!Arrays.equals(expectedDeleteData, actualDeleteData)) {
                            throw new IllegalStateException("Patch application failed: target file content mismatch, cannot apply patch");
                        }
                        dstPos += deleteLength;
                        continue block7;
                    }
                }
                throw new IllegalStateException("Patch file format error: unknown command code " + command);
            }
            if (dstPos != dstData.length) {
                throw new IllegalStateException("Patch application failed: target file not fully processed");
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] resultMD5 = md.digest(output.toByteArray());
            if (!Arrays.equals(expectedMD5, resultMD5)) {
                throw new IllegalStateException("Patch application failed: file checksum mismatch, patch may be corrupted");
            }
            if (output.size() == originalSrcSize) return output;
            Logger.getGlobal().warning("Warning: Size mismatch after applying patch, expected " + originalSrcSize + ", actual " + output.size());
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Failed to calculate MD5 checksum", e);
        }
    }

    public static void applyPatch(File patch, File dst, File outputFile) throws IOException {
        SimplePatcher.applyPatch(patch, dst, outputFile, null);
    }

    public static void applyPatch(File patchFile, File targetFile, File outputFile, @Nullable ICompress compression) throws IOException {
        SimplePatcher.validateFiles(patchFile, targetFile, outputFile);
        try (FileInputStream patchStream = new FileInputStream(patchFile);
             FileInputStream targetStream = new FileInputStream(targetFile);
             OutputStream outputStream = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);){
            ByteArrayOutputStream processedPatch = new ByteArrayOutputStream();
            SimplePatcher.processPatchData(patchStream, processedPatch, compression, false);
            try (ByteArrayInputStream processedPatchStream = new ByteArrayInputStream(processedPatch.toByteArray());){
                ByteArrayOutputStream patchedContent = (ByteArrayOutputStream)SimplePatcher.applyPatch(processedPatchStream, targetStream);
                patchedContent.writeTo(outputStream);
                outputStream.flush();
            }
        }
    }

    public static File applyPath(File patch, File dst) throws IOException {
        File outputFile = File.createTempFile("diff", ".tmp");
        try {
            SimplePatcher.applyPatch(patch, dst, outputFile);
            return outputFile;
        }
        catch (IOException e) {
            outputFile.delete();
            throw new IOException(e);
        }
    }

    private static void validateFiles(File patchFile, File destinationFile, File outputFile) throws IOException {
        if (!patchFile.exists()) {
            throw new IOException("Patch file does not exist");
        }
        if (!destinationFile.exists()) {
            throw new IOException("Destination file does not exist");
        }
        if (!outputFile.getName().endsWith(".tmp")) {
            if (outputFile.exists()) {
                throw new IOException("Output file already exists");
            }
            outputFile.createNewFile();
        }
    }

    private static void validatePatchFiles(File newFile, File oldFile, File patchFile) throws IOException {
        if (!newFile.exists()) {
            throw new IOException("New file does not exist");
        }
        if (!oldFile.exists()) {
            throw new IOException("Old file does not exist");
        }
        if (!patchFile.getName().endsWith(".sdiff")) {
            if (patchFile.exists()) {
                throw new IOException("Patch file already exists");
            }
            patchFile.createNewFile();
        }
    }

    private static void processPatchData(Object input, OutputStream output, @Nullable ICompress compression, boolean isCompressing) throws IOException {
        if (compression == null) {
            if (input instanceof ByteArrayOutputStream) {
                ((ByteArrayOutputStream)input).writeTo(output);
            } else if (input instanceof InputStream) {
                int read;
                InputStream inputStream = (InputStream)input;
                byte[] buffer = new byte[4096];
                while ((read = inputStream.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                }
            }
        } else if (isCompressing) {
            try (ByteArrayInputStream dataStream = input instanceof ByteArrayOutputStream ? new ByteArrayInputStream(((ByteArrayOutputStream)input).toByteArray()) : (ByteArrayInputStream)input;){
                compression.compress(dataStream, output);
            }
        } else {
            compression.decompress((InputStream)input, output);
        }
        output.flush();
    }

    private static byte[] readAllBytes(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

