/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.velocity.command.source;

import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.Locale;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import one.tranic.t.base.TBase;
import one.tranic.t.base.command.Operator;
import one.tranic.t.base.command.source.CommandSource;
import one.tranic.t.velocity.player.VelocityPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VelocitySource
implements CommandSource<com.velocitypowered.api.command.CommandSource, Player> {
    private final SimpleCommand.Invocation invocation;
    private final com.velocitypowered.api.command.CommandSource commandSource;
    private final VelocityPlayer player;

    public VelocitySource(com.velocitypowered.api.command.CommandSource commandSource) {
        this.invocation = null;
        this.commandSource = commandSource;
        this.player = commandSource instanceof Player ? new VelocityPlayer(commandSource) : null;
    }

    public VelocitySource(SimpleCommand.Invocation invocation) {
        this.invocation = invocation;
        this.commandSource = invocation.source();
        this.player = this.commandSource instanceof Player ? new VelocityPlayer(this.commandSource) : null;
    }

    public Operator getOperator() {
        if (this.player != null) {
            return new Operator(this.player.getUsername(), this.player.getUniqueId());
        }
        return TBase.console();
    }

    public com.velocitypowered.api.command.CommandSource getSource() {
        return this.commandSource;
    }

    public boolean isPlayer() {
        return this.player != null;
    }

    public String[] getArgs() {
        return (String[])this.invocation.arguments();
    }

    public int argSize() {
        return ((String[])this.invocation.arguments()).length;
    }

    @Nullable
    public Locale getLocale() {
        return this.player != null ? this.player.getLocale() : Locale.getDefault();
    }

    public boolean hasPermission(String permission) {
        return this.commandSource.hasPermission(permission);
    }

    public void sendMessage(String message) {
        this.commandSource.sendMessage((Component)Component.text((String)message));
    }

    public void sendMessage(@NotNull Component message) {
        this.commandSource.sendMessage(message);
    }

    public void showBossBar(@NotNull BossBar bossBar) {
        if (this.isPlayer()) {
            this.player.getSourcePlayer().showBossBar(bossBar);
        }
    }

    public void hideBossBar(@NotNull BossBar bossBar) {
        if (this.isPlayer()) {
            this.player.getSourcePlayer().hideBossBar(bossBar);
        }
    }

    public void clearBossBars() {
    }

    public void showTitle(@NotNull Title title) {
        if (this.isPlayer()) {
            this.player.getSourcePlayer().showTitle(title);
        }
    }

    public void clearTitle() {
        if (this.isPlayer()) {
            this.player.getSourcePlayer().clearTitle();
        }
    }

    @Nullable
    public VelocityPlayer asPlayer() {
        return this.player;
    }
}

