/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.velocity.player;

import com.velocitypowered.api.command.CommandSource;
import java.util.Locale;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import one.tranic.t.base.player.BedrockPlayer;
import one.tranic.t.base.player.Location;
import one.tranic.t.base.player.Player;
import one.tranic.t.velocity.TVelocity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VelocityPlayer
implements Player<com.velocitypowered.api.proxy.Player> {
    private final com.velocitypowered.api.proxy.Player player;
    private final BedrockPlayer<com.velocitypowered.api.proxy.Player> bedrockPlayer;

    public VelocityPlayer(CommandSource commandSource) {
        this((com.velocitypowered.api.proxy.Player)commandSource);
    }

    public VelocityPlayer(com.velocitypowered.api.proxy.Player player) {
        this.player = player;
        this.bedrockPlayer = new BedrockPlayer((Player)this);
    }

    @Nullable
    public static VelocityPlayer createPlayer(@Nullable com.velocitypowered.api.proxy.Player player) {
        if (player == null) {
            return null;
        }
        return new VelocityPlayer(player);
    }

    @Nullable
    public static VelocityPlayer createPlayer(@NotNull UUID uuid) {
        com.velocitypowered.api.proxy.Player p = TVelocity.getServer().getPlayer(uuid).orElse(null);
        return VelocityPlayer.createPlayer(p);
    }

    @Nullable
    public static VelocityPlayer createPlayer(@NotNull String username) {
        com.velocitypowered.api.proxy.Player p = TVelocity.getServer().getPlayer(username).orElse(null);
        return VelocityPlayer.createPlayer(p);
    }

    @NotNull
    public BedrockPlayer<com.velocitypowered.api.proxy.Player> toBedrockPlayer() {
        return this.bedrockPlayer;
    }

    @NotNull
    public String getUsername() {
        return this.player.getUsername();
    }

    @NotNull
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @NotNull
    public String getConnectedHost() {
        return this.player.getRemoteAddress().getAddress().getHostAddress();
    }

    @NotNull
    public Locale getLocale() {
        Locale locale = this.player.getEffectiveLocale();
        return locale != null ? locale : Locale.getDefault();
    }

    @Nullable
    public Location getLocation() {
        return null;
    }

    public long getPing() {
        long ping;
        if (this.isBedrockPlayer() && (ping = this.bedrockPlayer.ping()) != -1L) {
            return ping;
        }
        return this.player.getPing();
    }

    public boolean isOnline() {
        return this.player.isActive();
    }

    @Nullable
    public String getClientBrand() {
        if (this.isBedrockPlayer()) {
            return this.bedrockPlayer.platform();
        }
        return this.player.getClientBrand();
    }

    public com.velocitypowered.api.proxy.Player getSourcePlayer() {
        return this.player;
    }

    public boolean kick() {
        this.player.disconnect((Component)Component.text((String)"<kick by server>"));
        return true;
    }

    public boolean kick(String reason) {
        this.player.disconnect((Component)Component.text((String)reason));
        return true;
    }

    public boolean kick(@NotNull Component reason) {
        this.player.disconnect(reason);
        return true;
    }

    public void sendMessage(@NotNull String message) {
        this.player.sendMessage((Component)Component.text((String)message));
    }

    public void sendMessage(@NotNull Component message) {
        this.player.sendMessage(message);
    }
}

