package one.veriph.sdk.data

import one.veriph.sdk.R

enum class CancellationReason(val value: Int, val labelRes: Int, val iconRes: Int) {
    // INVERSE OTP RELATED
    INVERSE_NOT_WORKING(
        100,
        R.string.attempt_execution_label_inverse_failed,
        R.drawable.ic_outline_error_24
    ),
    INVERSE_NOT_WORKING_WHATSAPP(
        101,
        R.string.attempt_execution_label_inverse_failed_whatsapp,
        R.drawable.ic_outline_error_24
    ),

    INVERSE_CANT_SEND_MESSAGES(
        110,
        R.string.attempt_execution_label_inverse_cant_send,
        R.drawable.ic_baseline_comments_disabled_24
    ),
    INVERSE_CANT_SEND_MESSAGES_NO_WHATSAPP(
        111,
        R.string.attempt_execution_label_inverse_no_whatsapp,
        R.drawable.ic_baseline_comments_disabled_24
    ),

    // TRADITIONAL OTP RELATED
    TRADITIONAL_NOT_DELIVERED(
        200,
        R.string.attempt_execution_label_trad_undelivered,
        R.drawable.ic_outline_chat_error_24
    ),
    TRADITIONAL_NOT_DELIVERED_WHATSAPP(
        201,
        R.string.attempt_execution_label_trad_undelivered_whatsapp,
        R.drawable.ic_outline_chat_error_24
    ),

    // GENERAL APPLICABILITY
    NO_SERVICE(
        900,
        R.string.attempt_execution_label_no_service,
        R.drawable.ic_outline_signal_cellular_nodata_24
    ),
}

fun getCancellationReasonsForMethod(method: VerificationMethod): Array<CancellationReason> {
    when (method) {
        VerificationMethod.INVERSE_OTP_SMS ->
            return arrayOf(
                CancellationReason.INVERSE_NOT_WORKING,
                CancellationReason.INVERSE_CANT_SEND_MESSAGES,
                CancellationReason.NO_SERVICE,
            )

        VerificationMethod.INVERSE_OTP_WHATSAPP ->
            return arrayOf(
                CancellationReason.INVERSE_NOT_WORKING_WHATSAPP,
                CancellationReason.INVERSE_CANT_SEND_MESSAGES_NO_WHATSAPP,
            )

        VerificationMethod.OTP_SMS ->
            return arrayOf(
                CancellationReason.TRADITIONAL_NOT_DELIVERED,
                CancellationReason.NO_SERVICE,
            )

        VerificationMethod.OTP_WHATSAPP ->
            return arrayOf(
                CancellationReason.TRADITIONAL_NOT_DELIVERED_WHATSAPP,
            )

        VerificationMethod.ROBOCALL ->
            return arrayOf(
                CancellationReason.NO_SERVICE,
            )
    }
}