package one.veriph.sdk.data

import com.google.gson.Gson
import okhttp3.ResponseBody
import org.json.JSONObject

data class ErrorBundle(
    val internalErrorCode: Int,
    val errorMessage: String? = null,
    val rErrorMessage: Int? = null,
)

fun ResponseBody.getErrorObject(): ErrorBundle {
    val gson = Gson()
    val jsonObject = JSONObject(charStream().readText())
    return gson.fromJson(jsonObject.toString(), ErrorBundle::class.java)
}