package one.veriph.sdk.ui.util

import java.text.Normalizer
import java.util.Locale

fun getDefaultCountry(
    countryCodes: List<one.veriph.sdk.data.CountryCode>,
    selectedCountryCodeUuid: String? = null,
    default: one.veriph.sdk.data.CountryCode
): one.veriph.sdk.data.CountryCode {
    val prefilled = if (selectedCountryCodeUuid != null) {
        countryCodes.find { it.uuid == selectedCountryCodeUuid }
    } else null

    if (prefilled != null)
        return prefilled

    val localeCountry = Locale.getDefault().country
    val parsedLocale = countryCodes.find { it.iso3166Code == localeCountry }

    if (parsedLocale != null)
        return parsedLocale

    return default
}

fun getCountryName(item: one.veriph.sdk.data.CountryCode): String =
    Locale(Locale.getDefault().language, item.iso3166Code).displayCountry

fun CharSequence.unaccent(): String {
    val regex = "\\p{InCombiningDiacriticalMarks}+".toRegex()
    val temp = Normalizer.normalize(this, Normalizer.Form.NFD)
    return regex.replace(temp, "")
}

fun getFlagEmoji(countryIsoCode: String): String {
    val firstLetter = Character.codePointAt(countryIsoCode, 0) - 0x41 + 0x1F1E6
    val secondLetter = Character.codePointAt(countryIsoCode, 1) - 0x41 + 0x1F1E6
    return String(Character.toChars(firstLetter)) + String(Character.toChars(secondLetter))
}