package one.veriph.sdk.ui.verification.screen

import androidx.navigation.NavController
import androidx.navigation.NavGraphBuilder
import androidx.navigation.compose.composable
import one.veriph.sdk.ui.util.FlowScreen
import one.veriph.sdk.ui.verification.VerificationViewModel

fun NavGraphBuilder.openPhoneForm(
    viewModel: VerificationViewModel,
    onSubmit: () -> Unit
) {
    composable(FlowScreen.PhoneForm.route) {
        PhoneFormScreen(
            viewModel,
            onSubmit
        )
    }
}

fun NavController.navigateToPhoneForm() {
    this.popBackStack()
    this.navigate(FlowScreen.PhoneForm.route)
}