package one.veriph.sdk.data

data class PhoneBundle(
    val countryCodeUuid: String,
    val cellphoneNumber: String,
)

data class HelperBundle(
    val countryCodeUuid: String,
    val phoneNumber: String,
)

data class AttemptInput(
    val userAgent: String,
    val sessionUuid: String,
    val userPhoneNumber: PhoneBundle?,
    val userCancellationReason: Int?,
    val userIpAddress: String? = null,
)

data class GenericPayload(
    val hash: String?,
    val destination: String?,
    val expiresAt: Long,
)

data class AttemptCreationResponse(
    val uuid: String,
    val type: VerificationMethod,
    val userCanEditNumber: Boolean,
    val userPhoneNumberHint: String?,
    val payload: GenericPayload,
    val nudgeUser: Boolean,
    val helperData: HelperBundle?,
)

enum class AttemptStatus {
    OPENED,
    CLOSED,
    NEEDS_INPUT,
    EXCEEDED,
    ERROR
}

class AttemptBundle(
    val attemptCreationResponse: AttemptCreationResponse?,
    responseCode: Int?,
    errorCode: Int?
) {
    val status: AttemptStatus = if (errorCode == 20012)
        AttemptStatus.CLOSED
    else if (responseCode == 409 && errorCode == 14224)
        AttemptStatus.NEEDS_INPUT
    else if (responseCode == 400 && errorCode == 20014)
        AttemptStatus.EXCEEDED
    else if (attemptCreationResponse != null) AttemptStatus.OPENED
    else AttemptStatus.ERROR
}