package one.veriph.sdk.ui.util

import android.content.Context
import android.os.Build
import androidx.preference.PreferenceManager
import one.veriph.sdk.BuildConfig
import java.util.UUID

const val PREF_NAME_FINGERPRINT = "Veriph.One ID"

fun getFingerprint(context: Context): String {
    val sharedPreferences =
        PreferenceManager.getDefaultSharedPreferences(context)
    val storedFingerprint = sharedPreferences.getString(PREF_NAME_FINGERPRINT, null)
    if (storedFingerprint == null) {
        val packageName = context.packageName
        val fingerprint = generateFingerprint(packageName)
        sharedPreferences.edit().putString(PREF_NAME_FINGERPRINT, fingerprint).apply()
        return fingerprint
    }
    return storedFingerprint
}

fun generateFingerprint(packageName: String): String {
    val uniqueID = UUID.randomUUID().toString()
    val sdkVersion = Build.VERSION.SDK_INT
    val v1SdkVersion = BuildConfig.VERIPH_ONE_SDK_VERSION
    return "A_%%_${sdkVersion}" +
            "_%%_${packageName}" +
            "_%%_${Build.BRAND} ${Build.DEVICE} ${Build.MODEL}" +
            "_%%_${v1SdkVersion}" +
            "_%%_${uniqueID}"
}