package one.veriph.sdk.ui.util

import android.app.Activity
import android.content.Context
import android.content.Intent
import androidx.activity.result.contract.ActivityResultContract
import one.veriph.sdk.ui.verification.VerificationActivity

data class VerificationParams(
    val sessionUuid: String,
    val apiKey: String
)

class VerificationResultContract : ActivityResultContract<VerificationParams, String?>() {
    override fun createIntent(context: Context, input: VerificationParams) =
        Intent(context, VerificationActivity::class.java).apply {
            putExtra(VerificationActivity.EXTRA_SESSION_UUID, input.sessionUuid)
            putExtra(VerificationActivity.EXTRA_API_KEY, input.apiKey)
        }

    override fun parseResult(resultCode: Int, intent: Intent?): String? {
        if (resultCode != Activity.RESULT_OK) {
            return null
        }
        return intent?.getStringExtra(VerificationActivity.EXTRA_SESSION_UUID)
    }
}