package one.veriph.sdk.ui.verification.composable

import android.content.Context
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableLongStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import kotlinx.coroutines.delay
import one.veriph.sdk.R
import java.util.Calendar

@Composable
fun CountdownTimer(
    context: Context,
    attempt: one.veriph.sdk.data.AttemptCreationResponse,
    onExpiration: () -> Unit
) {
    val now = Calendar.getInstance().timeInMillis
    val durationSeconds = (attempt.payload.expiresAt - now) / 1000
    var secondsRemaining by remember { mutableLongStateOf(durationSeconds) }
    LaunchedEffect(key1 = secondsRemaining) {
        if (secondsRemaining > 0) {
            delay(1000)
            secondsRemaining -= 1
        } else {
            onExpiration()
        }
    }

    val minutes = secondsRemaining / 60
    val seconds = secondsRemaining % 60
    val res = context.resources

    Text(
        stringResource(
            id = R.string.attempt_execution_expiration,
            res.getQuantityString(R.plurals.minute_plurals, minutes.toInt(), minutes.toInt()),
            res.getQuantityString(R.plurals.second_plurals, seconds.toInt(), seconds.toInt()),
        ),
        textAlign = TextAlign.Center,
    )
}