package one.veriph.sdk.ui.verification.composable

import android.app.Activity
import androidx.compose.foundation.isSystemInDarkTheme
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.runtime.Composable
import androidx.compose.runtime.SideEffect
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.toArgb
import androidx.compose.ui.platform.LocalView
import androidx.core.view.WindowCompat
import one.veriph.sdk.data.SessionStyle
import one.veriph.sdk.ui.util.StateBundle
import one.veriph.sdk.ui.util.fromHex

object LightPaletteDefaults {
    const val PRIMARY = 0xFF5765FC
    const val SECONDARY = 0xFFFC73E9
    const val BACKGROUND = 0xFFFFFBFE
    const val TEXT = 0xFF1C1B1F

    const val WHITE = 0xFFFFFFFF
}

@Composable
fun CustomizableTheme(style: StateBundle<SessionStyle?>, content: @Composable () -> Unit) {
    val obtainedStyle = style.state

    // TODO: Integrate multi palette support
    val darkTheme: Boolean = isSystemInDarkTheme()
    var isLight = true
    var primaryColor = Color(LightPaletteDefaults.PRIMARY)
    var onPrimaryColor = Color(LightPaletteDefaults.WHITE)
    var secondaryColor = Color(LightPaletteDefaults.SECONDARY)
    var onSecondaryColor = Color(LightPaletteDefaults.WHITE)
    var backgroundColor = Color(LightPaletteDefaults.BACKGROUND)
    var surfaceColor = Color(LightPaletteDefaults.BACKGROUND)
    var textColor = Color(LightPaletteDefaults.TEXT)

    obtainedStyle?.palette?.let {
        if (it.size > 0) {
            val palette = it[0]
            isLight = palette.mode == "light"

            palette.primary?.main?.let {
                primaryColor = Color.fromHex(it)
            }
            palette.primary?.contrastText?.let {
                onPrimaryColor = Color.fromHex(it)
            }
            palette.secondary?.main?.let {
                secondaryColor = Color.fromHex(it)
            }
            palette.secondary?.contrastText?.let {
                onSecondaryColor = Color.fromHex(it)
            }
            palette.background?.default?.let {
                backgroundColor = Color.fromHex(it)
            }
            palette.background?.paper?.let {
                surfaceColor = Color.fromHex(it)
            }
            palette.text?.primary?.let {
                textColor = Color.fromHex(it)
            }
        }
    }

    val colorScheme = when {
        isLight -> lightColorScheme(
            primary = primaryColor,
            secondary = secondaryColor,
            background = backgroundColor,
            surface = surfaceColor,
            onPrimary = onPrimaryColor,
            onSecondary = onSecondaryColor,
            onBackground = textColor,
            onSurface = textColor,
        )

        else -> darkColorScheme(
            primary = primaryColor,
            secondary = secondaryColor,
            background = backgroundColor,
            surface = surfaceColor,
            onPrimary = onPrimaryColor,
            onSecondary = onSecondaryColor,
            onBackground = textColor,
            onSurface = textColor,
        )
    }
    val view = LocalView.current
    if (!view.isInEditMode) {
        SideEffect {
            val window = (view.context as Activity).window
            window.statusBarColor = colorScheme.primary.toArgb()
            WindowCompat.getInsetsController(window, view).isAppearanceLightStatusBars = darkTheme
        }
    }

    MaterialTheme(
        colorScheme = colorScheme,
        //typography = Typography,
        content = content
    )
}