package one.veriph.sdk.ui.verification.composable

import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import one.veriph.sdk.R

@Composable
fun PhoneNumberHint(
    numberHint: String,
    canEdit: Boolean,
    onEditNumber: () -> Unit,
    modifier: Modifier = Modifier
) {
    var str = stringResource(id = R.string.attempt_execution_hint, numberHint)
    if (canEdit)
        str += " ${stringResource(id = R.string.attempt_execution_hint_action)}"

    TextButton(
        enabled = canEdit,
        onClick = { onEditNumber() },
        modifier = modifier
    ) {
        Text(str, textAlign = TextAlign.Center)
    }
}