package one.veriph.sdk.ui.verification.screen

import androidx.navigation.NavController
import androidx.navigation.NavGraphBuilder
import androidx.navigation.compose.composable
import one.veriph.sdk.ui.util.FlowScreen
import one.veriph.sdk.ui.verification.VerificationViewModel

fun NavGraphBuilder.createAttempt(
    viewModel: VerificationViewModel,
    onExecution: () -> Unit,
    onFinish: () -> Unit,
    onInputNeeded: () -> Unit
) {
    composable(FlowScreen.AttemptCreation.route) {
        AttemptCreationScreen(
            viewModel,
            onExecution,
            onFinish,
            onInputNeeded
        )
    }
}

fun NavController.navigateToCreateAttempt() {
    this.popBackStack()
    this.navigate(FlowScreen.AttemptCreation.route)
}