package one.veriph.sdk.ui.verification.screen

import androidx.navigation.NavController
import androidx.navigation.NavGraphBuilder
import androidx.navigation.compose.composable
import one.veriph.sdk.ui.util.FlowScreen
import one.veriph.sdk.ui.verification.VerificationViewModel

fun NavGraphBuilder.executeAttempt(
    viewModel: VerificationViewModel,
    onExpiration: () -> Unit,
    onEditNumber: () -> Unit,
    onCancellation: (reason: Int) -> Unit,
) {
    composable(FlowScreen.AttemptExecution.route) {
        AttemptExecutionScreen(
            viewModel,
            onExpiration,
            onEditNumber,
            onCancellation,
        )
    }
}

fun NavController.navigateToAttemptExecution() {
    this.popBackStack()
    this.navigate(FlowScreen.AttemptExecution.route)
}