package one.veriph.sdk.ui.verification.screen

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import one.veriph.sdk.R
import one.veriph.sdk.data.VerificationMethod
import one.veriph.sdk.ui.verification.VerificationViewModel
import one.veriph.sdk.ui.verification.composable.AttemptExecutor
import one.veriph.sdk.ui.verification.composable.LoadingIndicator

@Composable
internal fun AttemptExecutionScreen(
    viewModel: VerificationViewModel,
    onExpiration: () -> Unit,
    onEditNumber: () -> Unit,
    onCancellation: (reason: Int) -> Unit,
) {
    val attemptState = viewModel.attempt.collectAsState()

    Surface(
        color = MaterialTheme.colorScheme.background
    ) {
        if (attemptState.value.state?.attemptCreationResponse == null) {
            Column(
                modifier = Modifier
                    .fillMaxSize(),
                verticalArrangement = Arrangement.Center,
                horizontalAlignment = Alignment.CenterHorizontally,
            ) {
                LoadingIndicator(R.string.attempt_execution_loading)
            }
        } else {
            val attempt: one.veriph.sdk.data.AttemptCreationResponse =
                attemptState.value.state?.attemptCreationResponse!!

            val attemptIsInverse = when (attempt.type) {
                VerificationMethod.INVERSE_OTP_SMS, VerificationMethod.INVERSE_OTP_WHATSAPP -> true
                else -> false
            }
            val sessionClosure = viewModel.sessionClosed.collectAsState()
            if (attemptIsInverse
                && !sessionClosure.value.isLoading
                && sessionClosure.value.state != null
                && !sessionClosure.value.state!!
            ) {
                viewModel.subscribeToStatus()
            }

            AttemptExecutor(
                viewModel,
                attempt,
                onExpiration,
                onEditNumber,
                onCancellation
            )
        }
    }
}