package one.veriph.sdk.data

import com.google.gson.Gson
import okhttp3.ResponseBody
import org.json.JSONObject

data class ErrorBundle(
    val internalErrorCode: Int,
    val errorMessage: String? = null,
    val rErrorMessage: Int? = null,
    var httpResStatusCode: Int? = null,
)

fun ResponseBody.getErrorObject(statusCode: Int? = null): ErrorBundle {
    val gson = Gson()
    val jsonObject = JSONObject(charStream().readText())
    val result = gson.fromJson(jsonObject.toString(), ErrorBundle::class.java)
    result.httpResStatusCode = statusCode
    return result
}