package one.veriph.sdk.data

data class ClientUIColor(
    val main: String?,
    val contrastText: String?,
)

data class ClientUITextColor(
    val primary: String?,
    val secondary: String?,
)

data class ClientUIBgColor(
    val paper: String?,
    val default: String?,
)

data class ClientUIPalette(
    val mode: String,
    val primary: ClientUIColor?,
    val secondary: ClientUIColor?,
    val text: ClientUITextColor?,
    val background: ClientUIBgColor?,
)

data class ClientUITextStyle(
    val color: String?,
)

data class ClientUITypography(
    val h3: ClientUITextStyle?,
    val h4: ClientUITextStyle?,
)

data class ClientUIBackground(
    val source: String,
    val type: String,
)

data class ClientUIImage(
    val source: String,
    val type: String,
)

data class ClientUILayout(
    val background: ClientUIBackground?,
    val logo: ClientUIImage?,
)

data class InvOtpSupportedLangLabel(
    val en: String,
    val es: String
)

data class InverseOtpConfiguration(
    val templatePrefix: TemplatePrefix
)

data class TemplatePrefix(
    val sms: InvOtpSupportedLangLabel,
    val whatsApp: InvOtpSupportedLangLabel
)

data class SessionConfiguration(
    val locale: String,
    val inverseOtp: InverseOtpConfiguration
)

data class SessionStyle(
    val palette: ArrayList<ClientUIPalette>?,
    val typography: ClientUITypography?,
    val layout: ClientUILayout?,
    val configuration: SessionConfiguration
)