package one.veriph.sdk.data

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
data class FontUsage(
    val sizeInSP: Int? = null,
) : Parcelable

@Parcelize
data class FontUsageBundle(
    val displayLarge: FontUsage? = null,
    val displayMedium: FontUsage? = null,
    val displaySmall: FontUsage? = null,
    val headlineLarge: FontUsage? = null,
    val headlineMedium: FontUsage? = null,
    val headlineSmall: FontUsage? = null,
    val titleLarge: FontUsage? = null,
    val titleMedium: FontUsage? = null,
    val titleSmall: FontUsage? = null,
    val bodyLarge: FontUsage? = null,
    val bodyMedium: FontUsage? = null,
    val bodySmall: FontUsage? = null,
    val labelLarge: FontUsage? = null,
    val labelMedium: FontUsage? = null,
    val labelSmall: FontUsage? = null,
) : Parcelable

@Parcelize
data class FontConfig(
    val resId: Int,
    val weight: Int,
    val usage: FontUsageBundle,
) : Parcelable

@Parcelize
data class ForcedUIElements(val forcedLanguage: ForcedLanguage?, val forcedMode: ForcedMode?) :
    Parcelable

@Parcelize
data class ForcedLanguage(val language: String) : Parcelable

@Parcelize
sealed class ForcedMode : Parcelable {
    data object DarkMode : ForcedMode()
    data object LightMode : ForcedMode()
}

@Parcelize
data class UIConfig(
    val typography: List<List<FontConfig>>?,
    val forcedUIElements: ForcedUIElements?
) :
    Parcelable
