package one.veriph.sdk.network

import okhttp3.ResponseBody
import one.veriph.sdk.data.SessionStyle
import one.veriph.sdk.data.VerificationStatusParams
import retrofit2.Call
import retrofit2.Response
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.Header
import retrofit2.http.POST
import retrofit2.http.Path
import retrofit2.http.Query
import retrofit2.http.Streaming

private const val API_KEY_HEADER_NAME = "x-api-key"
private const val LANGUAGE_HEADER_NAME = "accept-language"

interface VerificationApi {
    @GET("country-codes/v1.0.0")
    suspend fun getCountryCodes(
        @Header(API_KEY_HEADER_NAME) apiKey: String
    ): Response<List<one.veriph.sdk.data.CountryCode>>

    @GET("session-style/v1.0.0")
    suspend fun getSessionStyle(
        @Header(API_KEY_HEADER_NAME) apiKey: String,
        @Header(LANGUAGE_HEADER_NAME) languages: String,
        @Query("sessionUuid") sessionUuid: String
    ): Response<SessionStyle>

    @POST("create-attempt/v1.0.0")
    suspend fun createAttempt(
        @Header(API_KEY_HEADER_NAME) apiKey: String,
        @Header(LANGUAGE_HEADER_NAME) languages: String,
        @Body input: one.veriph.sdk.data.AttemptInput
    ): Response<one.veriph.sdk.data.AttemptCreationResponse>

    @POST("submit-attempt/v1.0.0")
    suspend fun submitAttempt(
        @Header(API_KEY_HEADER_NAME) apiKey: String,
        @Header(LANGUAGE_HEADER_NAME) languages: String,
        @Body input: one.veriph.sdk.data.AttemptSubmission
    ): Response<one.veriph.sdk.data.AttemptStatusResponse>

    @POST("verification-status/v1.0.0")
    suspend fun getVerificationStatus(
        @Header(API_KEY_HEADER_NAME) apiKey: String,
        @Header(LANGUAGE_HEADER_NAME) languages: String,
        @Body input: VerificationStatusParams
    ): Response<one.veriph.sdk.data.AttemptStatusResponse>

    @GET("events/session/v1.0.0/{id}")
    @Streaming
    fun subscribeToEvents(
        @Path("id") uuid: String,
        @Header("READ_TIMEOUT") readTimeout: Int,
    ): Call<ResponseBody>
}