package one.veriph.sdk.ui.util

import android.util.Log
import androidx.compose.material3.Typography
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.Font
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.TextUnit
import androidx.compose.ui.unit.sp
import one.veriph.sdk.data.FontConfig
import one.veriph.sdk.data.FontUsage
import one.veriph.sdk.data.UIConfig

private data class FontHolder(val familyIndex: Int, val weight: FontWeight, val size: TextUnit)

private fun transformFontSize(value: FontUsage, default: TextStyle): TextUnit {
    return value.sizeInSP?.sp ?: default.fontSize
}

private fun transformFontHolder(
    value: FontHolder?,
    fonts: List<FontFamily>,
    default: TextStyle
): TextStyle {
    value?.let {
        return TextStyle(
            fontFamily = fonts[it.familyIndex],
            fontWeight = it.weight,
            fontSize = it.size
        )
    }
    return default
}

fun getTypographyConfig(baseTypography: Typography, config: UIConfig?): Typography {
    try {
        if (config?.typography != null && config.typography.isNotEmpty()) {
            var fontFamilies = emptyList<FontFamily>()
            var displayLarge: FontHolder? = null
            var displayMedium: FontHolder? = null
            var displaySmall: FontHolder? = null
            var headlineLarge: FontHolder? = null
            var headlineMedium: FontHolder? = null
            var headlineSmall: FontHolder? = null
            var titleLarge: FontHolder? = null
            var titleMedium: FontHolder? = null
            var titleSmall: FontHolder? = null
            var bodyLarge: FontHolder? = null
            var bodyMedium: FontHolder? = null
            var bodySmall: FontHolder? = null
            var labelLarge: FontHolder? = null
            var labelMedium: FontHolder? = null
            var labelSmall: FontHolder? = null
            for ((index, family: List<FontConfig>) in config.typography.withIndex()) {
                var fonts = emptyList<Font>()
                family.forEach { fontConfig ->
                    val weight = FontWeight(fontConfig.weight)
                    fonts = fonts.plus(
                        Font(
                            fontConfig.resId,
                            weight,
                        )
                    )
                    fontConfig.usage.displayLarge?.let {
                        displayLarge = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.displayLarge)
                        )
                    }
                    fontConfig.usage.displayMedium?.let {
                        displayMedium = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.displayMedium)
                        )
                    }
                    fontConfig.usage.displaySmall?.let {
                        displaySmall = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.displaySmall)
                        )
                    }
                    fontConfig.usage.headlineLarge?.let {
                        headlineLarge = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.headlineLarge)
                        )
                    }
                    fontConfig.usage.headlineMedium?.let {
                        headlineMedium = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.headlineMedium)
                        )
                    }
                    fontConfig.usage.headlineSmall?.let {
                        headlineSmall = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.headlineSmall)
                        )
                    }
                    fontConfig.usage.titleLarge?.let {
                        titleLarge = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.titleLarge)
                        )
                    }
                    fontConfig.usage.titleMedium?.let {
                        titleMedium = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.titleMedium)
                        )
                    }
                    fontConfig.usage.titleSmall?.let {
                        titleSmall = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.titleSmall)
                        )
                    }
                    fontConfig.usage.bodyLarge?.let {
                        bodyLarge = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.bodyLarge)
                        )
                    }
                    fontConfig.usage.bodyMedium?.let {
                        bodyMedium = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.bodyMedium)
                        )
                    }
                    fontConfig.usage.bodySmall?.let {
                        bodySmall = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.bodySmall)
                        )
                    }
                    fontConfig.usage.labelLarge?.let {
                        labelLarge = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.labelLarge)
                        )
                    }
                    fontConfig.usage.labelMedium?.let {
                        labelMedium = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.labelMedium)
                        )
                    }
                    fontConfig.usage.labelSmall?.let {
                        labelSmall = FontHolder(
                            index,
                            weight,
                            transformFontSize(it, baseTypography.labelSmall)
                        )
                    }
                }
                fontFamilies = fontFamilies.plus(FontFamily(fonts))
            }
            return Typography(
                displayLarge = transformFontHolder(
                    displayLarge,
                    fontFamilies,
                    baseTypography.displayLarge
                ),
                displayMedium = transformFontHolder(
                    displayMedium,
                    fontFamilies,
                    baseTypography.displayMedium
                ),
                displaySmall = transformFontHolder(
                    displaySmall,
                    fontFamilies,
                    baseTypography.displaySmall
                ),
                headlineLarge = transformFontHolder(
                    headlineLarge,
                    fontFamilies,
                    baseTypography.headlineLarge
                ),
                headlineMedium = transformFontHolder(
                    headlineMedium,
                    fontFamilies,
                    baseTypography.headlineMedium
                ),
                headlineSmall = transformFontHolder(
                    headlineSmall,
                    fontFamilies,
                    baseTypography.headlineSmall
                ),
                titleLarge = transformFontHolder(
                    titleLarge,
                    fontFamilies,
                    baseTypography.titleLarge
                ),
                titleMedium = transformFontHolder(
                    titleMedium,
                    fontFamilies,
                    baseTypography.titleMedium
                ),
                titleSmall = transformFontHolder(
                    titleSmall,
                    fontFamilies,
                    baseTypography.titleSmall
                ),
                bodyLarge = transformFontHolder(bodyLarge, fontFamilies, baseTypography.bodyLarge),
                bodyMedium = transformFontHolder(
                    bodyMedium,
                    fontFamilies,
                    baseTypography.bodyMedium
                ),
                bodySmall = transformFontHolder(bodySmall, fontFamilies, baseTypography.bodySmall),
                labelLarge = transformFontHolder(
                    labelLarge,
                    fontFamilies,
                    baseTypography.labelLarge
                ),
                labelMedium = transformFontHolder(
                    labelMedium,
                    fontFamilies,
                    baseTypography.labelMedium
                ),
                labelSmall = transformFontHolder(
                    labelSmall,
                    fontFamilies,
                    baseTypography.labelSmall
                ),
            )
        }
    } catch (error: Error) {
        val tag = "[Veriph.One]"
        Log.e(tag, "Ignoring UIConfig object. Error found while parsing params:")
        Log.e(tag, error.toString())
        error.printStackTrace()
    }
    return baseTypography
}