package one.veriph.sdk.ui.util

import androidx.compose.ui.graphics.Color

fun onlyContainsNumbers(str: String): Boolean {
    val pattern = Regex("^\\d+\$")
    return str.matches(pattern)
}

fun extendColorIfNeeded(colorStr: String): String {
    // Converts #000 to #000000
    if (colorStr.length == 4) {
        val raw = colorStr.replace("#", "")
        var res = ""
        for (char in raw) {
            res = "$res$char$char"
        }
        return "#$res"
    }
    return colorStr
}

fun Color.Companion.fromHex(colorString: String) =
    Color(android.graphics.Color.parseColor(extendColorIfNeeded(colorString)))