package one.veriph.sdk.ui.util

import android.content.Intent
import android.os.Build
import android.util.Log
import one.veriph.sdk.data.UIConfig
import one.veriph.sdk.ui.verification.VerificationActivity

class UIUtils {
    companion object {
        fun getUIConfigFromIntent(intent: Intent): UIConfig? {
            return try {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU)
                    intent.getParcelableExtra(
                        VerificationActivity.EXTRA_UI_CONFIG,
                        UIConfig::class.java
                    )
                else
                    intent.getParcelableExtra(VerificationActivity.EXTRA_UI_CONFIG)
            } catch (error: Error) {
                val tag = "[Veriph.One]"
                Log.e(tag, "Ignoring UIConfig object. Error found while parsing params:")
                Log.e(tag, error.toString())
                error.printStackTrace()

                null
            }
        }
    }
}