package one.veriph.sdk.ui.util

import one.veriph.sdk.data.FontConfig
import one.veriph.sdk.data.FontUsage
import one.veriph.sdk.data.FontUsageBundle
import one.veriph.sdk.data.ForcedUIElements
import one.veriph.sdk.data.UIConfig

/**
 * A helper class with static methods that can help test the SDK customization options and generate
 * UIConfig objects with pre-defined states.
 */
class VeriphOneFontUtils {
    companion object {
        /**
         * Generates a FontUsageBundle object that can be used to set a font
         * on all text objects of the SDK. It keeps the default sizes intact.
         *
         * @return A FontUsageBundle object targeting all text objects and no font size overrides.
         */
        fun generateFontUsageBundleTargetingAll(): FontUsageBundle {
            return FontUsageBundle(
                FontUsage(),
                FontUsage(),
                FontUsage(),
                FontUsage(),
                FontUsage(),
                FontUsage(),
                FontUsage(),
                FontUsage(),
                FontUsage(),
                FontUsage(),
                FontUsage(),
                FontUsage(),
                FontUsage(),
                FontUsage(),
                FontUsage(),
            )
        }

        /**
         * Creates a UIConfig object that sets the provided font
         * on all text objects of the SDK. It keeps the default
         * sizes intact and won't support font weights (e.g., bold, thin)
         * @param resId A resource id pointing to your font in form of R.font.your_font
         * @param weight The default weight of the font to be used. It should comply with
         *          the constraints of androidx.compose.ui.text.font.FontWeight. You can
         *          set this param using that exact class, for example: FontWeight.Normal.weight
         *
         * @return A complete UIConfig object that will use the same font for all text objects.
         *          Which you can later integrate into VerificationParams to start a verification
         *          flow using custom fonts.
         */
        fun generateConfigForDefaultFontForAllElements(
            resId: Int,
            weight: Int,
            forcedUIElements: ForcedUIElements?
        ): UIConfig {
            return UIConfig(
                listOf(
                    listOf(
                        FontConfig(
                            resId,
                            weight,
                            generateFontUsageBundleTargetingAll()
                        )
                    )
                ),
                forcedUIElements
            )
        }
    }
}