package one.veriph.sdk.ui.verification.composable

import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.padding
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.outlined.ArrowDropDown
import androidx.compose.material3.ButtonDefaults
import androidx.compose.material3.Icon
import androidx.compose.material3.OutlinedTextFieldDefaults
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import one.veriph.sdk.R
import one.veriph.sdk.data.CountryCode
import one.veriph.sdk.ui.util.getCountryName
import one.veriph.sdk.ui.util.getFlagEmoji

@Composable
fun CountryCodeSelectorRow(
    modifier: Modifier = Modifier,
    item: CountryCode,
    isSingleElement: Boolean = false,
    onClick: (item: CountryCode) -> Unit,
) {
    val newModifier = if (isSingleElement)
        modifier.border(
            border = ButtonDefaults.outlinedButtonBorder,
            shape = OutlinedTextFieldDefaults.shape,
        ) else modifier

    Row(
        modifier = newModifier
            .clickable { onClick(item) },
        verticalAlignment = Alignment.CenterVertically
    ) {
        Text(
            text = getFlagEmoji(item.iso3166Code),
            fontSize = 18.sp,
            modifier = Modifier
                .padding(12.dp)
        )
        Text(
            text = "(+${item.phoneCode})",
            modifier = Modifier
                .weight(0.25f)
        )
        Text(
            text = getCountryName(item),
            modifier = Modifier.weight(0.75f)
        )
        if (isSingleElement) {
            Icon(
                imageVector = Icons.Outlined.ArrowDropDown,
                contentDescription = stringResource(id = R.string.form_phone_hint_country_code),
                modifier = Modifier
                    .padding(12.dp)
            )
        }
    }
}