package one.veriph.sdk.ui.verification.composable

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import one.veriph.sdk.data.SessionStyle
import one.veriph.sdk.ui.util.fromHex

@Composable
fun CustomV1Title(stringRes: Int, style: SessionStyle?) {
    var color = MaterialTheme.colorScheme.secondary
    style?.typography?.h3?.color?.let {
        color = Color.fromHex(it)
    }
    Text(
        stringResource(id = stringRes),
        modifier = Modifier.padding(bottom = 12.dp),
        textAlign = TextAlign.Center,
        color = color,
        style = MaterialTheme.typography.titleMedium
    )
}