package one.veriph.sdk.ui.verification.composable

import android.app.Activity
import androidx.compose.foundation.isSystemInDarkTheme
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.runtime.SideEffect
import androidx.compose.ui.graphics.toArgb
import androidx.compose.ui.platform.LocalView
import androidx.core.view.WindowCompat
import one.veriph.sdk.data.ForcedMode
import one.veriph.sdk.data.SessionStyle
import one.veriph.sdk.data.UIConfig
import one.veriph.sdk.ui.util.StateBundle
import one.veriph.sdk.ui.util.getDefaultPalette
import one.veriph.sdk.ui.util.getPalettes
import one.veriph.sdk.ui.util.getTypographyConfig

@Composable
fun CustomizableTheme(
    style: StateBundle<SessionStyle?>,
    uiConfig: UIConfig?,
    content: @Composable () -> Unit
) {
    val obtainedStyle = style.state

    var isLight = !isSystemInDarkTheme()

    uiConfig?.forcedUIElements?.forcedMode?.let { forceMode ->
        isLight = forceMode == ForcedMode.LightMode
    }

    var paletteToUse = getDefaultPalette(isLight)
    if (obtainedStyle != null && obtainedStyle.palette !== null) {
        val (lightPalette, darkPalette) = getPalettes(obtainedStyle.palette)
        if (isLight && lightPalette != null)
            paletteToUse = lightPalette
        else if (darkPalette != null)
            paletteToUse = darkPalette
    }


    val view = LocalView.current
    if (!view.isInEditMode) {
        SideEffect {
            val window = (view.context as Activity).window
            window.statusBarColor = paletteToUse.primary.toArgb()
            WindowCompat.getInsetsController(window, view).isAppearanceLightStatusBars = !isLight
        }
    }

    MaterialTheme(
        colorScheme = paletteToUse,
        typography = getTypographyConfig(MaterialTheme.typography, uiConfig),
        content = content
    )
}


