package one.veriph.sdk.ui.verification.composable

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Button
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import one.veriph.sdk.R
import one.veriph.sdk.data.ErrorBundle

@Composable
fun ErrorHolder(
    errorBundle: ErrorBundle,
    onRetry: (() -> Unit)? = null
) {
    Column(
        modifier = Modifier
            .fillMaxSize()
            .padding(48.dp),
        verticalArrangement = Arrangement.Center,
        horizontalAlignment = Alignment.CenterHorizontally,
    ) {
        Text(
            stringResource(
                id = R.string.error_holder_body,
                errorBundle.internalErrorCode,
                errorBundle.errorMessage
                    ?: if (errorBundle.rErrorMessage != null)
                        stringResource(id = errorBundle.rErrorMessage) else ""
            ),
            modifier = Modifier.padding(bottom = 12.dp),
            textAlign = TextAlign.Center
        )
        if (onRetry != null) {
            Button(onClick = { onRetry() }) {
                Text(stringResource(id = R.string.error_holder_btn_retry))
            }
        }
    }
}