package one.veriph.sdk.ui.verification.composable

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Icon
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import one.veriph.sdk.data.CancellationReason

@Composable
fun HelpCenterRow(item: CancellationReason, elementColor: Color, onClick: () -> Unit) {
    Row(
        verticalAlignment = Alignment.CenterVertically,
        modifier = Modifier
            .fillMaxWidth()
            .clickable { onClick() }
            .padding(horizontal = 32.dp, vertical = 12.dp)
    ) {
        Icon(
            painter = painterResource(item.iconRes),
            contentDescription = stringResource(id = item.labelRes),
            tint = elementColor
        )
        Text(
            stringResource(id = item.labelRes),
            modifier = Modifier.padding(start = 32.dp),
            color = elementColor
        )
    }
}