package one.veriph.sdk.ui.verification.screen

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import one.veriph.sdk.R
import one.veriph.sdk.data.AttemptStatus
import one.veriph.sdk.data.ErrorBundle
import one.veriph.sdk.ui.verification.VerificationViewModel
import one.veriph.sdk.ui.verification.composable.ErrorHolder
import one.veriph.sdk.ui.verification.composable.LoadingIndicator
import one.veriph.sdk.util.InternalErrorCodes

@Composable
internal fun AttemptCreationScreen(
    viewModel: VerificationViewModel
) {
    val attemptBundle = viewModel.attempt.collectAsState()

    val attempt = attemptBundle.value.state
    val error = attemptBundle.value.error
    val isNew = attempt == null && error == null

    Surface(
        color = MaterialTheme.colorScheme.background
    ) {
        Column(
            modifier = Modifier
                .fillMaxSize()
                .padding(32.dp),
            verticalArrangement = Arrangement.Center,
            horizontalAlignment = Alignment.CenterHorizontally,
        ) {
            if (isNew || attemptBundle.value.isLoading) {
                LoadingIndicator(R.string.attempt_execution_loading)
            } else {
                if (attempt != null) {
                    if (attempt.status == AttemptStatus.ERROR) {
                        ErrorHolder(
                            errorBundle = ErrorBundle(
                                InternalErrorCodes.UnknownAttemptError.value
                            ),
                            onRetry = {
                                viewModel.invalidateAttempt()
                            })
                    }
                } else if (error != null) {
                    ErrorHolder(errorBundle = error, onRetry = {
                        viewModel.invalidateAttempt()
                    })
                }
            }
        }
    }
}