package one.veriph.sdk.ui.verification.screen

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import one.veriph.sdk.R
import one.veriph.sdk.data.AttemptCreationResponse
import one.veriph.sdk.ui.verification.VerificationViewModel
import one.veriph.sdk.ui.verification.composable.AttemptExecutor
import one.veriph.sdk.ui.verification.composable.LoadingIndicator

@Composable
internal fun AttemptExecutionScreen(
    viewModel: VerificationViewModel,
    onEditNumber: () -> Unit,
) {
    val attemptState = viewModel.attempt.collectAsState()

    Surface(
        color = MaterialTheme.colorScheme.background
    ) {
        if (attemptState.value.state?.attemptCreationResponse == null) {
            Column(
                modifier = Modifier
                    .fillMaxSize(),
                verticalArrangement = Arrangement.Center,
                horizontalAlignment = Alignment.CenterHorizontally,
            ) {
                LoadingIndicator(R.string.attempt_execution_loading)
            }
        } else {
            val attempt: AttemptCreationResponse =
                attemptState.value.state?.attemptCreationResponse!!

            AttemptExecutor(
                viewModel,
                attempt,
                onEditNumber,
            )
        }
    }
}