package one.veriph.sdk.ui.verification.screen

import android.app.Application
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.saveable.rememberSaveable
import androidx.compose.runtime.setValue
import androidx.navigation.compose.NavHost
import androidx.navigation.compose.composable
import androidx.navigation.compose.rememberNavController
import one.veriph.sdk.data.UIConfig
import one.veriph.sdk.ui.util.FlowScreen
import one.veriph.sdk.ui.verification.VerificationViewModel
import one.veriph.sdk.ui.verification.composable.CustomizableTheme

@Composable
fun MainScreen(
    appContainer: Application, viewModel: VerificationViewModel, uiConfig: UIConfig?
) {
    val navController = rememberNavController()
    val style by viewModel.sessionStyle.collectAsState()
    var firstScreen by rememberSaveable { mutableStateOf(viewModel.currentScreen.value.route) }
    val currentScreen by viewModel.currentScreen.collectAsState()

    CustomizableTheme(style = style, uiConfig = uiConfig) {
        NavHost(
            navController = navController, startDestination = firstScreen
        ) {
            composable(FlowScreen.Setup.route) {
                SetupScreen(
                    viewModel = viewModel,
                )
            }

            composable(FlowScreen.PhoneForm.route) {
                PhoneCaptureScreen(
                    viewModel = viewModel,
                )
            }

            composable(FlowScreen.AttemptCreation.route) {
                AttemptCreationScreen(
                    viewModel = viewModel,
                )
            }

            composable(FlowScreen.AttemptExecution.route) {
                AttemptExecutionScreen(viewModel = viewModel, onEditNumber = {
                    navController.navigateToPhoneForm()
                })
            }
        }
    }

    if (firstScreen != currentScreen.route) {
        firstScreen = currentScreen.route
        when (currentScreen) {
            FlowScreen.Setup -> navController.navigateToPhoneForm()
            FlowScreen.PhoneForm -> navController.navigateToPhoneForm()
            FlowScreen.AttemptCreation -> navController.navigateToCreateAttempt()
            FlowScreen.AttemptExecution -> navController.navigateToAttemptExecution()
        }
    }
}