package one.veriph.sdk.ui.verification.screen

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.sizeIn
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import coil.compose.AsyncImage
import one.veriph.sdk.R
import one.veriph.sdk.ui.verification.VerificationViewModel
import one.veriph.sdk.ui.verification.composable.CustomV1Title
import one.veriph.sdk.ui.verification.composable.LoadingIndicator
import one.veriph.sdk.ui.verification.composable.PhoneForm

@Composable
internal fun PhoneCaptureScreen(
    viewModel: VerificationViewModel,
) {
    val countryCodes = viewModel.countryCodes.collectAsState()
    val attempt = viewModel.attempt.collectAsState()
    val style = viewModel.sessionStyle.collectAsState().value.state

    val countryCodeUuid: String? =
        attempt.value.state?.attemptCreationResponse?.helperData?.countryCodeUuid
    val cellphoneNumber: String? =
        attempt.value.state?.attemptCreationResponse?.helperData?.phoneNumber

    Surface(
        color = MaterialTheme.colorScheme.background
    ) {
        Column(
            modifier = Modifier
                .fillMaxSize()
                .padding(32.dp),
            verticalArrangement = Arrangement.Center,
            horizontalAlignment = Alignment.CenterHorizontally,
        ) {
            if (countryCodes.value.state == null) {
                LoadingIndicator(R.string.form_phone_loading)
            } else {
                style?.layout?.logo?.let {
                    if (it.type == "url")
                        AsyncImage(
                            model = it.source,
                            contentDescription = null,
                            Modifier
                                .padding(bottom = 12.dp, start = 36.dp, end = 36.dp)
                                .fillMaxWidth()
                                .sizeIn(maxHeight = 76.dp)
                        )
                }

                CustomV1Title(stringRes = R.string.form_phone_title, style = style)
                Text(
                    stringResource(id = R.string.form_phone_description),
                    modifier = Modifier.padding(bottom = 24.dp),
                    textAlign = TextAlign.Center,
                )
                PhoneForm(
                    viewModel,
                    countryCodes.value.state!!,
                    countryCodeUuid,
                    cellphoneNumber,
                )
            }
        }
    }
}
