package one.veriph.sdk.ui.verification.screen

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import one.veriph.sdk.R
import one.veriph.sdk.ui.verification.VerificationViewModel
import one.veriph.sdk.ui.verification.composable.ErrorHolder
import one.veriph.sdk.ui.verification.composable.LoadingIndicator

@Composable
fun SetupScreen(
    viewModel: VerificationViewModel
) {
    val stateObj = viewModel.sessionStyle.collectAsState()

    val error = stateObj.value.error
    val sessionStyle = stateObj.value.state
    val isNew = sessionStyle == null && error == null

    Surface(
        color = MaterialTheme.colorScheme.background
    ) {
        Column(
            modifier = Modifier
                .fillMaxSize()
                .padding(32.dp),
            verticalArrangement = Arrangement.Center,
            horizontalAlignment = Alignment.CenterHorizontally,
        ) {
            if (isNew || stateObj.value.isLoading) {
                LoadingIndicator(R.string.setup_loading)
            } else if (error != null) {
                ErrorHolder(errorBundle = error, onRetry = {
                    viewModel.retryInitialization()
                })
            }
        }
    }
}