package one.veriph.sdk.ui.verification.screen

import androidx.navigation.NavController
import androidx.navigation.navOptions
import one.veriph.sdk.ui.util.FlowScreen

fun NavController.navigateToSetup() {
    this.popBackStack()
    this.navigate(FlowScreen.Setup.route, navOptions = navOptions {
        launchSingleTop = true
    })
}

fun NavController.navigateToPhoneForm() {
    this.popBackStack()
    this.navigate(FlowScreen.PhoneForm.route, navOptions = navOptions {
        launchSingleTop = true
    })
}

fun NavController.navigateToCreateAttempt() {
    this.popBackStack()
    this.navigate(FlowScreen.AttemptCreation.route, navOptions = navOptions {
        launchSingleTop = true
    })
}

fun NavController.navigateToAttemptExecution() {
    this.popBackStack()
    this.navigate(FlowScreen.AttemptExecution.route, navOptions = navOptions {
        launchSingleTop = true
    })
}