package one.veriph.sdk.util

import com.google.gson.Gson
import one.veriph.sdk.data.LanguageBundle
import java.util.Locale

class APIUtils {
    companion object {
        fun isSessionClosedFromStatus(statusCode: Int): Boolean {
            return statusCode == 412
        }

        fun getDeviceLang(): String {
            return Locale.getDefault().toString()
        }

        fun createLanguagesBundle(forcedLang: String?): String {
            val currentLang = getDeviceLang()
            val payload = LanguageBundle(currentLang, null, forcedLang)
            val gson = Gson()
            return gson.toJson(payload)
        }
    }
}