package one.xingyi.cddscenario

import scala.language.higherKinds

trait Specification[P, R] {
  def scenarios: Seq[Scenario[P, R]]
  def useCases: Seq[UseCase[P, R]]

}
case class Specification1[P, R](scenarios: Seq[Scenario[P, R]], useCases: Seq[UseCase[P, R]]) extends Specification[P, R] {
}
case class Specification2[P1, P2, R](scenarios: Seq[Scenario[(P1, P2), R]], useCases: Seq[UseCase[(P1, P2), R]]) extends Specification[(P1, P2), R] {
}

object Specification {
  def apply[T[_, _] : HasScenarios : HasUseCases, P, R](t: T[P, R])(implicit hasUseCases: HasUseCases[T], hasScenarios: HasScenarios[T]): Specification[P, R] =
    Specification1[P, R](hasScenarios.allScenarios(t), hasUseCases.useCases(t))

}