/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core;

import java.util.List;
import java.util.Optional;
import one.xingyi.core.EntityRegister;
import one.xingyi.core.endpoints.HasBookmarkAndUrl;
import one.xingyi.core.httpClient.ResourceDetailsRequest;
import one.xingyi.core.httpClient.server.domain.ResourceDetails;
import one.xingyi.core.utils.Lists;

class SimpleEntityRegister
implements EntityRegister {
    private final List<String> legalValues;
    final List<HasBookmarkAndUrl> companions;

    public SimpleEntityRegister(List<HasBookmarkAndUrl> companions) {
        this.companions = companions;
        this.legalValues = Lists.map(companions, c -> c.bookmarkAndUrl().bookmark);
    }

    @Override
    public Optional<ResourceDetails> apply(ResourceDetailsRequest resourceDetailsRequest) {
        return Lists.find(this.companions, c -> c.bookmarkAndUrl().bookmark.equals(resourceDetailsRequest.entityName)).map(b -> b.bookmarkAndUrl().urlPattern).map(ResourceDetails::new);
    }

    @Override
    public List<String> registered() {
        return this.legalValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleEntityRegister)) {
            return false;
        }
        SimpleEntityRegister other = (SimpleEntityRegister)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$legalValues = this.legalValues;
        List<String> other$legalValues = other.legalValues;
        if (this$legalValues == null ? other$legalValues != null : !((Object)this$legalValues).equals(other$legalValues)) {
            return false;
        }
        List<HasBookmarkAndUrl> this$companions = this.companions;
        List<HasBookmarkAndUrl> other$companions = other.companions;
        return !(this$companions == null ? other$companions != null : !((Object)this$companions).equals(other$companions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleEntityRegister;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $legalValues = this.legalValues;
        result = result * 59 + ($legalValues == null ? 43 : ((Object)$legalValues).hashCode());
        List<HasBookmarkAndUrl> $companions = this.companions;
        result = result * 59 + ($companions == null ? 43 : ((Object)$companions).hashCode());
        return result;
    }

    public String toString() {
        return "SimpleEntityRegister(legalValues=" + this.legalValues + ", companions=" + this.companions + ")";
    }
}

