/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core;

import java.util.List;
import java.util.Optional;
import one.xingyi.core.EntityRegister;
import one.xingyi.core.endpoints.IResourceEndpointAcceptor;
import one.xingyi.core.endpoints.MethodPathAndDescription;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.httpClient.ResourceDetailsRequest;
import one.xingyi.core.utils.Lists;

class EntityEndpointAcceptor
implements IResourceEndpointAcceptor<ResourceDetailsRequest> {
    final EntityRegister entityRegister;
    final List<String> registered;

    public EntityEndpointAcceptor(EntityRegister entityRegister) {
        this.entityRegister = entityRegister;
        this.registered = entityRegister.registered();
    }

    public List<MethodPathAndDescription> description() {
        return Lists.map(this.registered, r -> new MethodPathAndDescription("get", r, EntityEndpointAcceptor.class.getSimpleName()));
    }

    public Optional<ResourceDetailsRequest> apply(ServiceRequest serviceRequest) {
        if (serviceRequest.method.equalsIgnoreCase("get") && serviceRequest.urlSegments().size() == 2) {
            String entityname = serviceRequest.path;
            if (this.entityRegister.registered().contains(entityname)) {
                return Optional.of(new ResourceDetailsRequest(entityname));
            }
        }
        return Optional.empty();
    }

    public String method() {
        return "get";
    }

    public String templatedPath() {
        return "/{entity}";
    }

    public String toString() {
        return "EntityEndpointAcceptor(entityRegister=" + this.entityRegister + ", registered=" + this.registered + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityEndpointAcceptor)) {
            return false;
        }
        EntityEndpointAcceptor other = (EntityEndpointAcceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityRegister this$entityRegister = this.entityRegister;
        EntityRegister other$entityRegister = other.entityRegister;
        if (this$entityRegister == null ? other$entityRegister != null : !this$entityRegister.equals(other$entityRegister)) {
            return false;
        }
        List<String> this$registered = this.registered;
        List<String> other$registered = other.registered;
        return !(this$registered == null ? other$registered != null : !((Object)this$registered).equals(other$registered));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityEndpointAcceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityRegister $entityRegister = this.entityRegister;
        result = result * 59 + ($entityRegister == null ? 43 : $entityRegister.hashCode());
        List<String> $registered = this.registered;
        result = result * 59 + ($registered == null ? 43 : ((Object)$registered).hashCode());
        return result;
    }
}

