/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import one.xingyi.core.EntityRegister;
import one.xingyi.core.endpoints.EndPoint;
import one.xingyi.core.endpoints.EndpointContext;
import one.xingyi.core.endpoints.HasBookmarkAndUrl;
import one.xingyi.core.endpoints.MethodPathAndDescription;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.httpClient.ResourceDetailsRequest;
import one.xingyi.core.httpClient.server.companion.ResourceDetailsCompanion;
import one.xingyi.core.httpClient.server.domain.ResourceDetails;
import one.xingyi.core.mediatype.IXingYiServerMediaTypeDefn;
import one.xingyi.core.sdk.IXingYiResource;
import one.xingyi.core.utils.Lists;

public class ResourceDefinitionEndPoint
implements EndPoint {
    final EntityRegister register;
    final IXingYiServerMediaTypeDefn<ResourceDetails> mediaTypeDefn;

    public ResourceDefinitionEndPoint(EndpointContext<?> context, List<HasBookmarkAndUrl> companions) {
        this.register = EntityRegister.apply(companions);
        this.mediaTypeDefn = ResourceDetailsCompanion.companion.lensMediaDefn(context);
    }

    public List<MethodPathAndDescription> description() {
        return Lists.map(this.register.registered(), url -> new MethodPathAndDescription("get", url, ResourceDefinitionEndPoint.class.getSimpleName()));
    }

    public CompletableFuture<Optional<ServiceResponse>> apply(ServiceRequest serviceRequest) {
        if (serviceRequest.method.equalsIgnoreCase("get")) {
            Optional optionalResourceDetails = (Optional)this.register.apply(new ResourceDetailsRequest(serviceRequest.path));
            return CompletableFuture.completedFuture(optionalResourceDetails.map(rd -> new ServiceResponse(200, this.mediaTypeDefn.makeDataAndDefn(this.mediaTypeDefn.makeContextForJson(serviceRequest), s -> "", (IXingYiResource)rd).asString(), List.of())));
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    public ResourceDefinitionEndPoint(EntityRegister register, IXingYiServerMediaTypeDefn<ResourceDetails> mediaTypeDefn) {
        this.register = register;
        this.mediaTypeDefn = mediaTypeDefn;
    }
}

