/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.strings;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringWriter;
import one.xingyi.core.strings.ParseException;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class Strings$ {
    public static Strings$ MODULE$;

    static {
        new Strings$();
    }

    public Function1<String, Tuple2<String, String>> splitInTwo(String separator) {
        return (Function1 & Serializable & scala.Serializable)s -> {
            String[] stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split(separator))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Strings$.$anonfun$splitInTwo$3(x$2)));
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                throw new ParseException(new StringBuilder(69).append("Cannot split a string into two non empty parts using [").append(separator).append("] string was [").append((String)s).append("]").toString());
            }
            String left = (String)((SeqLike)option.get()).apply(0);
            String right = (String)((SeqLike)option.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)left, (Object)right);
            return tuple2;
        };
    }

    public String splitInTwo$default$1() {
        return ":";
    }

    public String withoutStringBefore(char beforeChar, String s) {
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s)).dropWhile((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Strings$.$anonfun$withoutStringBefore$1(beforeChar, BoxesRunTime.unboxToChar((Object)x$3)))))).drop(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Option<String> toOption(String s) {
        None$ none$;
        block3: {
            block2: {
                if (s == null) break block2;
                String string = s;
                String string2 = "";
                if (string != null ? !string.equals(string2) : string2 != null) break block3;
            }
            none$ = None$.MODULE$;
            return none$;
        }
        none$ = new Some((Object)s);
        return none$;
    }

    public Option<String> startsWithAndSnips(String start, String s) {
        return s.startsWith(start) ? new Some((Object)s.substring(start.length() + 1)) : None$.MODULE$;
    }

    public String removeOptional$(String s) {
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s)).reverse())).dropWhile((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Strings$.$anonfun$removeOptional$$1(BoxesRunTime.unboxToChar((Object)x$4)))))).reverse();
    }

    public String uppercaseFirst(String s) {
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s)).take(1))).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToCharacter((char)RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$5)))), Predef$.MODULE$.StringCanBuildFrom()))).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s)).drop(1))), Predef$.MODULE$.StringCanBuildFrom());
    }

    public String lowercaseFirst(String s) {
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s)).take(1))).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToCharacter((char)RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$6)))), Predef$.MODULE$.StringCanBuildFrom()))).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s)).drop(1))), Predef$.MODULE$.StringCanBuildFrom());
    }

    public String useStringWriter(Function1<StringWriter, BoxedUnit> fn) {
        StringWriter writer = new StringWriter();
        fn.apply((Object)writer);
        writer.flush();
        return writer.toString();
    }

    public String classNameOfObject(Object obj) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(obj.getClass().getSimpleName())).dropRight(1);
    }

    public String indent(String filler, int depth) {
        return ((TraversableOnce)List$.MODULE$.fill(depth, (Function0 & Serializable & scala.Serializable)() -> filler)).mkString("");
    }

    public String indentTuple(String filler, int left, int mid, Tuple2<String, String> tuple) {
        int padding = mid - left - ((String)tuple._1()).length();
        return new StringBuilder(0).append(this.indent(filler, left)).append(tuple._1()).append(this.indent(filler, padding)).append(tuple._2()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public String escapeJson(String raw) {
        void var2_2;
        String escaped = raw;
        escaped = escaped.replace("\\", "\\\\");
        escaped = escaped.replace("\"", "\\\"");
        escaped = escaped.replace("\b", "\\b");
        escaped = escaped.replace("\f", "\\f");
        escaped = escaped.replace("\n", "\\n");
        escaped = escaped.replace("\r", "\\r");
        escaped = escaped.replace("\t", "\\t");
        return var2_2;
    }

    public Map<String, String> paramsToMap(String s) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split("&"))).map((Function1 & Serializable & scala.Serializable)x$7 -> {
            String[] stringArray = x$7.split("=");
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                throw new RuntimeException(new StringBuilder(32).append("Do not understand [").append(stringArray).append("] as part of ").append(s).toString());
            }
            String name = (String)((SeqLike)option.get()).apply(0);
            String value = (String)((SeqLike)option.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)name, (Object)value);
            return tuple2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public String removeWhiteSpace(String s) {
        return s.replaceAll("\\s+", "");
    }

    public String ellipses(int maxLength, String s) {
        return s.length() > maxLength ? new StringBuilder(2).append((String)new StringOps(Predef$.MODULE$.augmentString(s)).take(maxLength)).append("..").toString() : s;
    }

    public String lastSection(String marker, String s) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split(marker))).last();
    }

    public String lastButOneSection(String marker, String s) {
        String[] split = s.split(marker);
        String[] splitDroppedRight = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split)).dropRight(1);
        String result = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splitDroppedRight)).last();
        return result;
    }

    public String allButlastSection(String marker, String s) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split(marker))).dropRight(1))).mkString(marker);
    }

    public <X> Tuple2<X, String> recordPrintln(Function0<X> x) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        Object result = Console$.MODULE$.withOut(new PrintStream(bytes), x);
        return new Tuple2(result, (Object)bytes.toString("UTF-8"));
    }

    public String trimChar(char trim, String s) {
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s)).dropWhile((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Strings$.$anonfun$trimChar$1(trim, BoxesRunTime.unboxToChar((Object)x$8)))))).reverse())).dropWhile((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)Strings$.$anonfun$trimChar$2(trim, BoxesRunTime.unboxToChar((Object)x$9)))))).reverse();
    }

    public String cleanString(String s, String acceptedChars) {
        return new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s)).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)Strings$.$anonfun$cleanString$1(acceptedChars, BoxesRunTime.unboxToChar((Object)x$10)))))).mkString();
    }

    public String cleanString$default$2() {
        return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_- ";
    }

    public String uri(Seq<String> parts) {
        return ((TraversableOnce)parts.map((Function1 & Serializable & scala.Serializable)s -> MODULE$.trimChar('/', (String)s), Seq$.MODULE$.canBuildFrom())).mkString("/");
    }

    public static final /* synthetic */ boolean $anonfun$splitInTwo$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$withoutStringBefore$1(char beforeChar$1, char x$3) {
        return x$3 != beforeChar$1;
    }

    public static final /* synthetic */ boolean $anonfun$removeOptional$$1(char x$4) {
        return x$4 == '$';
    }

    public static final /* synthetic */ boolean $anonfun$trimChar$1(char trim$1, char x$8) {
        return x$8 == trim$1;
    }

    public static final /* synthetic */ boolean $anonfun$trimChar$2(char trim$1, char x$9) {
        return x$9 == trim$1;
    }

    public static final /* synthetic */ boolean $anonfun$cleanString$1(String acceptedChars$1, char x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(acceptedChars$1)).contains((Object)BoxesRunTime.boxToCharacter((char)x$10));
    }

    private Strings$() {
        MODULE$ = this;
    }
}

