/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.strings;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringWriter;
import one.xingyi.core.strings.ParseException;
import one.xingyi.core.strings.StringsUrlExtractor;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichChar$;

public final class Strings$ {
    public static final Strings$ MODULE$ = new Strings$();

    public Function1<String, List<String>> split(String separator) {
        return (Function1 & Serializable)s -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])s.split(separator)), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1))))), (Function1 & Serializable)x$2 -> x$2.trim(), ClassTag$.MODULE$.apply(String.class))).toList();
    }

    public String split$default$1() {
        return "\\.";
    }

    public Nothing$ splitInTwoException(String separator, String s) {
        throw new ParseException(new StringBuilder(69).append("Cannot split a string into two non empty parts using [").append(separator).append("] string was [").append(s).append("]").toString());
    }

    public Function1<String, Tuple2<String, String>> splitInTwo(String separator, Function2<String, String, String> defaultRhs) {
        return (Function1 & Serializable)s -> {
            SeqOps seqOps;
            Tuple2 tuple2;
            SeqOps seqOps2;
            List list = (List)MODULE$.split(separator).apply(s);
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0) {
                String left = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
                tuple2 = new Tuple2((Object)left, defaultRhs.apply((Object)separator, s));
            } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                String left = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                String right = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                tuple2 = new Tuple2((Object)left, (Object)right);
            } else {
                throw new ParseException(new StringBuilder(69).append("Cannot split a string into two non empty parts using [").append(separator).append("] string was [").append((String)s).append("]").toString());
            }
            return tuple2;
        };
    }

    public String splitInTwo$default$1() {
        return ":";
    }

    public Function2<String, String, String> splitInTwo$default$2() {
        return (Function2 & Serializable)(separator, s) -> MODULE$.splitInTwoException((String)separator, (String)s);
    }

    public String withoutStringBefore(char beforeChar, String s) {
        return StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Strings$.$anonfun$withoutStringBefore$1(beforeChar, BoxesRunTime.unboxToChar((Object)x$3))))), 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Option<String> toOption(String s) {
        None$ none$;
        block3: {
            block2: {
                if (s == null) break block2;
                String string = s;
                String string2 = "";
                if (string != null ? !string.equals(string2) : string2 != null) break block3;
            }
            none$ = None$.MODULE$;
            return none$;
        }
        none$ = new Some((Object)s);
        return none$;
    }

    public Option<String> startsWithAndSnips(String start, String s) {
        return s.startsWith(start) ? new Some((Object)s.substring(start.length() + 1)) : None$.MODULE$;
    }

    public String removeOptional$(String s) {
        return StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(s))), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Strings$.$anonfun$removeOptional$$1(BoxesRunTime.unboxToChar((Object)x$4))))));
    }

    public String uppercaseFirst(String s) {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(s), 1)), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToCharacter((char)RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$5)))))), StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(s), 1));
    }

    public String lowercaseFirst(String s) {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(s), 1)), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToCharacter((char)RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$6)))))), StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(s), 1));
    }

    public String useStringWriter(Function1<StringWriter, BoxedUnit> fn) {
        StringWriter writer = new StringWriter();
        fn.apply((Object)writer);
        writer.flush();
        return writer.toString();
    }

    public String classNameOfObject(Object obj) {
        return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(obj.getClass().getSimpleName()), 1);
    }

    public String indent(String filler, int depth) {
        return List$.MODULE$.fill(depth, (Function0 & Serializable)() -> filler).mkString("");
    }

    public String indentTuple(String filler, int left, int mid, Tuple2<String, String> tuple) {
        int padding = mid - left - ((String)tuple._1()).length();
        return new StringBuilder(0).append(this.indent(filler, left)).append(tuple._1()).append(this.indent(filler, padding)).append(tuple._2()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public String escapeJson(String raw) {
        void var2_2;
        String escaped = raw;
        escaped = escaped.replace("\\", "\\\\");
        escaped = escaped.replace("\"", "\\\"");
        escaped = escaped.replace("\b", "\\b");
        escaped = escaped.replace("\f", "\\f");
        escaped = escaped.replace("\n", "\\n");
        escaped = escaped.replace("\r", "\\r");
        escaped = escaped.replace("\t", "\\t");
        return var2_2;
    }

    public Map<String, String> paramsToMap(String s) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])s.split("&")), (Function1 & Serializable)x$7 -> {
            Object object;
            String[] stringArray = x$7.split("=");
            if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
                throw new RuntimeException(new StringBuilder(32).append("Do not understand [").append(stringArray).append("] as part of ").append(s).toString());
            }
            String name = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            String value = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            Tuple2 tuple2 = new Tuple2((Object)name, (Object)value);
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public String removeWhiteSpace(String s) {
        return s.replaceAll("\\s+", "");
    }

    public String ellipses(int maxLength, String s) {
        return s.length() > maxLength ? new StringBuilder(2).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(s), maxLength)).append("..").toString() : s;
    }

    public String lastSection(String marker, String s) {
        return (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])s.split(marker)));
    }

    public String lastButOneSection(String marker, String s) {
        String[] split = s.split(marker);
        String[] splitDroppedRight = (String[])ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])split), 1);
        String result = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])splitDroppedRight));
        return result;
    }

    public String allButlastSection(String marker, String s) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])s.split(marker)), 1)).mkString(marker);
    }

    public <X> Tuple2<X, String> recordPrintln(Function0<X> x) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        Object result = Console$.MODULE$.withOut(new PrintStream(bytes), x);
        return new Tuple2(result, (Object)bytes.toString("UTF-8"));
    }

    public String trimChar(char trim, String s) {
        return StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Strings$.$anonfun$trimChar$1(trim, BoxesRunTime.unboxToChar((Object)x$8))))))), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)Strings$.$anonfun$trimChar$2(trim, BoxesRunTime.unboxToChar((Object)x$9))))));
    }

    public String cleanString(String s, String acceptedChars) {
        return StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(acceptedChars), BoxesRunTime.unboxToChar((Object)x$10))))));
    }

    public String cleanString$default$2() {
        return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_- ";
    }

    public String uri(Seq<String> parts) {
        return ((IterableOnceOps)parts.map((Function1 & Serializable)s -> MODULE$.trimChar('/', (String)s))).mkString("/");
    }

    public Function1<String, List<String>> extractFromUrl(String template) {
        return new StringsUrlExtractor(template);
    }

    public static final /* synthetic */ boolean $anonfun$withoutStringBefore$1(char beforeChar$1, char x$3) {
        return x$3 != beforeChar$1;
    }

    public static final /* synthetic */ boolean $anonfun$removeOptional$$1(char x$4) {
        return x$4 == '$';
    }

    public static final /* synthetic */ boolean $anonfun$trimChar$1(char trim$1, char x$8) {
        return x$8 == trim$1;
    }

    public static final /* synthetic */ boolean $anonfun$trimChar$2(char trim$1, char x$9) {
        return x$9 == trim$1;
    }

    private Strings$() {
    }
}

