/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.fp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import one.xingyi.fp.PartialFunction;
import one.xingyi.fp.PartialFunctionAlwaysTrue;
import one.xingyi.helpers.Permutations;

public interface IPartialFunction<From, To>
extends Function<From, To> {
    public boolean isDefinedAt(From var1);

    default public IPartialFunction<From, To> orElse(IPartialFunction<From, To> other) {
        return IPartialFunction.of(from -> this.isDefinedAt(from) || other.isDefinedAt(from), from -> this.isDefinedAt(from) ? this.apply(from) : other.apply(from));
    }

    public static <From, To> IPartialFunction<From, To> always(Function<From, To> fn) {
        return new PartialFunctionAlwaysTrue<Object, To>(q -> true, fn);
    }

    public static <From, To> To applyOrError(IPartialFunction<From, To> pfn, From from) {
        if (pfn.isDefinedAt(from)) {
            return (To)pfn.apply(from);
        }
        throw new IllegalArgumentException("Not defined at " + from);
    }

    public static <From, To> To applyOr(IPartialFunction<From, To> pfn, Supplier<To> defValue, From from) {
        return (To)(pfn.isDefinedAt(from) ? pfn.apply(from) : defValue.get());
    }

    public static <From, To> IPartialFunction<From, To> of(Predicate<From> isDefinedAt, Function<From, To> fn) {
        return new PartialFunction<From, To>(isDefinedAt, fn);
    }

    public static <From, To> IPartialFunction<From, To> notNull(Function<From, To> fn) {
        return IPartialFunction.of(Objects::nonNull, fn);
    }

    public static <From, To> Function<From, List<To>> mapFn(Collection<IPartialFunction<From, To>> fns) {
        return from -> {
            ArrayList result = new ArrayList();
            for (IPartialFunction fn : fns) {
                if (!fn.isDefinedAt(from)) continue;
                result.add(fn.apply(from));
            }
            return result;
        };
    }

    public static <From, To, Result> Function<From, Result> mapReduceFn(Collection<IPartialFunction<From, To>> fns, Function<List<To>, Result> reduceFn) {
        Function fn = IPartialFunction.mapFn(fns);
        return from -> reduceFn.apply((List)fn.apply(from));
    }

    public static <From, To> Function<From, To> chain(To defValue, Collection<IPartialFunction<From, To>> fns) {
        return from -> {
            for (IPartialFunction fn : fns) {
                if (!fn.isDefinedAt(from)) continue;
                return fn.apply(from);
            }
            return defValue;
        };
    }

    public static <From, To> IPartialFunction<From, To> chainToPf(Collection<IPartialFunction<From, To>> pfs) {
        return IPartialFunction.of(from -> pfs.stream().anyMatch(pf -> pf.isDefinedAt(from)), from -> {
            for (IPartialFunction pf : pfs) {
                if (!pf.isDefinedAt(from)) continue;
                return pf.apply(from);
            }
            throw new IllegalArgumentException("Software error: not defined at " + from);
        });
    }

    public static <From, To> Predicate<List<Boolean>> isOkToUseBooleans(List<IPartialFunction<From, To>> pfns) {
        return booleans -> {
            if (pfns.size() != booleans.size()) {
                throw new IllegalArgumentException("Software error: pfns and booleans must be the same size. Pfns: " + pfns.size() + " booleans " + booleans.size() + " ->" + booleans);
            }
            for (int i = 0; i < pfns.size(); ++i) {
                if (!(pfns.get(i) instanceof PartialFunctionAlwaysTrue) || ((Boolean)booleans.get(i)).booleanValue()) continue;
                return false;
            }
            return true;
        };
    }

    public static <From, To> Function<List<Boolean>, List<To>> applyListBooleans(List<IPartialFunction<From, To>> pfns, From from) {
        return IPartialFunction.applyListBooleans(pfns, from, true);
    }

    public static <From, To> Function<List<Boolean>, List<To>> applyListBooleans(List<IPartialFunction<From, To>> pfns, From from, boolean throwExceptionIfNotDefined) {
        return booleans -> {
            if (pfns.size() != booleans.size()) {
                throw new IllegalArgumentException("Software error: pfns and booleans must be the same size");
            }
            ArrayList result = new ArrayList();
            for (int i = 0; i < pfns.size(); ++i) {
                if (!((Boolean)booleans.get(i)).booleanValue()) continue;
                IPartialFunction pfn = (IPartialFunction)pfns.get(i);
                if (pfn.isDefinedAt(from)) {
                    result.add(pfn.apply(from));
                    continue;
                }
                if (!throwExceptionIfNotDefined) continue;
                throw new IllegalArgumentException("Software error: pfn " + i + " not defined at " + from);
            }
            return result;
        };
    }

    public static <From, To> Stream<List<To>> permutations(List<IPartialFunction<From, To>> pfns, From from) {
        Predicate<List<Boolean>> isOkToUseBooleans = IPartialFunction.isOkToUseBooleans(pfns);
        Function<List<Boolean>, List<To>> applyListBooleans = IPartialFunction.applyListBooleans(pfns, from);
        return Permutations.permutate((int)pfns.size()).filter(isOkToUseBooleans).map(applyListBooleans);
    }

    public static <From, To, Res> void forEachPermutation(List<IPartialFunction<From, To>> pfns, From from, BiConsumer<List<Boolean>, List<To>> consumer) {
        IPartialFunction.forEachPermutation(pfns, from, consumer, true);
    }

    public static <From, To, Res> void forEachPermutation(List<IPartialFunction<From, To>> pfns, From from, BiConsumer<List<Boolean>, List<To>> consumer, boolean throwExceptionIfNotDefined) {
        Predicate<List<Boolean>> isOkToUseBooleans = IPartialFunction.isOkToUseBooleans(pfns);
        Function applyListBooleans = IPartialFunction.applyListBooleans(pfns, from, throwExceptionIfNotDefined);
        Permutations.permutate((int)pfns.size()).filter(isOkToUseBooleans).forEach(booleans -> consumer.accept((List<Boolean>)booleans, (List)applyListBooleans.apply((List<Boolean>)booleans)));
    }
}

