/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.fp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import one.xingyi.interfaces.BiFunctionWithException;
import one.xingyi.interfaces.ConsumerWithException;
import one.xingyi.interfaces.FunctionWithException;

public interface ListComprehensionsForExceptions {
    public static <T, T1> List<T1> mapE(Iterable<T> iterable, FunctionWithException<T, T1> fn) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        for (T t : iterable) {
            result.add(fn.apply(t));
        }
        return result;
    }

    public static <T> List<T> filterE(Iterable<T> iterable, FunctionWithException<T, Boolean> filter) throws Exception {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            if (!((Boolean)filter.apply(t)).booleanValue()) continue;
            result.add(t);
        }
        return result;
    }

    public static <T, T1> List<T1> collectE(Iterable<T> iterable, FunctionWithException<T, Boolean> filter, FunctionWithException<T, T1> fn) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        for (T t : iterable) {
            if (!((Boolean)filter.apply(t)).booleanValue()) continue;
            result.add(fn.apply(t));
        }
        return result;
    }

    public static <T, T1> List<T1> collectByClassE(Iterable<T> iterable, Class<T1> theClass, FunctionWithException<T, T1> fn) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        for (T t : iterable) {
            if (!theClass.isInstance(t)) continue;
            result.add(fn.apply(t));
        }
        return result;
    }

    public static <T> void foreachE(Iterable<T> iterable, ConsumerWithException<T> fn) throws Exception {
        for (T t : iterable) {
            fn.accept(t);
        }
    }

    public static <T, T1> List<T1> flatMapE(Iterable<T> iterable, FunctionWithException<T, ? extends Collection<T1>> fn) throws Exception {
        ArrayList result = new ArrayList();
        for (T t : iterable) {
            result.addAll((Collection)fn.apply(t));
        }
        return result;
    }

    public static <Id, T> Map<Id, T> toIdMapE(Iterable<T> iterable, FunctionWithException<T, Id> fn) throws Exception {
        HashMap<Object, T> result = new HashMap<Object, T>();
        for (T t : iterable) {
            result.put(fn.apply(t), t);
        }
        return result;
    }

    public static <T, K, V> Map<K, V> toMapE(Iterable<T> iterable, FunctionWithException<T, K> keyFn, FunctionWithException<T, V> vFn) throws Exception {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (T t : iterable) {
            result.put(keyFn.apply(t), vFn.apply(t));
        }
        return result;
    }

    public static <Acc, T> Acc foldE(Iterable<T> iterable, BiFunctionWithException<Acc, T, Acc> foldFn, Acc zero) throws Exception {
        Object result = zero;
        for (T t : iterable) {
            result = foldFn.apply(result, t);
        }
        return result;
    }

    public static <T> T reduceE(Iterable<T> iterable, BiFunctionWithException<T, T, T> foldFn) throws Exception {
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("reduceE has been called with an empty list");
        }
        Object result = iterator.next();
        while (iterator.hasNext()) {
            result = foldFn.apply(result, iterator.next());
        }
        return result;
    }
}

