/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.fp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import one.xingyi.interfaces.BiFunctionWithException;
import one.xingyi.interfaces.ConsumerWithException;
import one.xingyi.interfaces.FunctionWithException;

public interface StreamComprehensionsForExceptions {
    public static <T, T1> Stream<T1> mapE(Stream<T> stream, FunctionWithException<T, T1> fn) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            result.add(fn.apply(iterator.next()));
        }
        return result.stream();
    }

    public static <T> List<T> filterE(Stream<T> stream, FunctionWithException<T, Boolean> filter) throws Exception {
        ArrayList result = new ArrayList();
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            if (!((Boolean)filter.apply(t)).booleanValue()) continue;
            result.add(t);
        }
        return result;
    }

    public static <T, T1> List<T1> collectE(Stream<T> stream, FunctionWithException<T, Boolean> filter, FunctionWithException<T, T1> fn) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            if (!((Boolean)filter.apply(t)).booleanValue()) continue;
            result.add(fn.apply(t));
        }
        return result;
    }

    public static <T, T1> List<T1> collectByClassE(Stream<T> stream, Class<T1> theClass, FunctionWithException<T, T1> fn) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            if (!theClass.isInstance(t)) continue;
            result.add(fn.apply(t));
        }
        return result;
    }

    public static <T> void forEachE(Stream<T> stream, ConsumerWithException<T> fn) throws Exception {
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            fn.accept(iterator.next());
        }
    }

    public static <T, T1> List<T1> flatMapE(Stream<T> stream, FunctionWithException<T, ? extends Collection<T1>> fn) throws Exception {
        ArrayList result = new ArrayList();
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            result.addAll((Collection)fn.apply(iterator.next()));
        }
        return result;
    }

    public static <Id, T> Map<Id, T> toIdMapE(Stream<T> stream, FunctionWithException<T, Id> fn) throws Exception {
        HashMap result = new HashMap();
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            result.put(fn.apply(t), t);
        }
        return result;
    }

    public static <T, K, V> Map<K, V> toMapE(Stream<T> stream, FunctionWithException<T, K> keyFn, FunctionWithException<T, V> vFn) throws Exception {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            result.put(keyFn.apply(t), vFn.apply(t));
        }
        return result;
    }

    public static <Acc, T> Acc foldE(Stream<T> stream, BiFunctionWithException<Acc, T, Acc> foldFn, Acc zero) throws Exception {
        Object result = zero;
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            result = foldFn.apply(result, iterator.next());
        }
        return result;
    }

    public static <T> T reduceE(Stream<T> stream, BiFunctionWithException<T, T, T> foldFn) throws Exception {
        Iterator iterator = stream.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("reduceE has been called with an empty list");
        }
        Object result = iterator.next();
        while (iterator.hasNext()) {
            result = foldFn.apply(result, iterator.next());
        }
        return result;
    }
}

