/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public interface MapHelpers {
    public static <K, V, V1> Map<K, V1> map(Map<K, V> map, BiFunction<K, V, V1> fn) {
        HashMap<K, V1> result = new HashMap<K, V1>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.put(entry.getKey(), fn.apply(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public static <V> String print(Map<String, V> map, BiFunction<String, V, String> fn) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>(map.keySet());
        Collections.sort(list);
        int maxLength = list.stream().mapToInt(String::length).max().orElse(0);
        for (String key : list) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(String.format("%-" + maxLength + "s", key));
            sb.append(" ");
            sb.append(fn.apply(key, map.get(key)));
        }
        return sb.toString();
    }
}

