/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import one.xingyi.helpers.StringHelper;

public interface MapHelpers {
    public static <K, V, V1> Map<K, V1> map(Map<K, V> map, BiFunction<K, V, V1> fn) {
        HashMap<K, V1> result = new HashMap<K, V1>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.put(entry.getKey(), fn.apply(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public static <V> String jsonPrint(String separator, Map<String, V> map, BiFunction<String, V, String> fn) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        ArrayList<String> list = new ArrayList<String>(map.keySet());
        Collections.sort(list);
        int maxLength = list.stream().mapToInt(String::length).max().orElse(0) + 2;
        for (String key : list) {
            if (sb.length() > 2) {
                sb.append(separator);
            }
            sb.append("  ");
            sb.append(String.format("%-" + maxLength + "s", StringHelper.doubleQuote.apply(key)));
            sb.append(":");
            sb.append(fn.apply(key, map.get(key)));
        }
        sb.append("\n}");
        return sb.toString();
    }
}

