/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.helpers;

import java.util.Arrays;
import java.util.function.Function;

public interface StringHelper {
    public static final Function<String, String> doubleQuote = StringHelper.quote("\"", "\"");
    public static final Function<String, String> brackets = StringHelper.quote("{", "}");

    public static String quoteIfNeeded(Object o) {
        if (Number.class.isAssignableFrom(o.getClass())) {
            return o.toString();
        }
        return '\"' + o.toString() + '\"';
    }

    public static String quoteIfNeededForJson(Object o) {
        if (Number.class.isAssignableFrom(o.getClass())) {
            return o.toString();
        }
        String s = o.toString();
        if (s.startsWith("{") && s.endsWith("}")) {
            return s;
        }
        return '\"' + o.toString() + '\"';
    }

    public static String toSingleQuotes(String s) {
        return s.replaceAll("\"", "'");
    }

    public static String toDoubleQuotes(String s) {
        return s.replaceAll("'", "\"");
    }

    public static String removeWhiteSpace(String s) {
        return s.replaceAll("\\s", "");
    }

    public static String sanitizeForObjectName(String url) {
        return url.replaceAll("[^a-zA-Z0-9]", "_");
    }

    public static String toJsonObject(Object ... avs) {
        return "{" + StringHelper.toAttributeValue(",", avs) + "}";
    }

    public static String toAttributeValue(String separator, Object ... avs) {
        if (avs.length % 2 != 0) {
            throw new RuntimeException("Odd number of attribute values" + avs.length + "\n" + Arrays.asList(avs));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < avs.length; i += 2) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append('\"');
            sb.append(avs[i]);
            sb.append("\":");
            sb.append(StringHelper.quoteIfNeededForJson(avs[i + 1]));
        }
        return sb.toString();
    }

    public static Function<String, String> quote(String open, String close) {
        return s -> open + s + close;
    }
}

