/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.json;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.optics.Getter;
import one.xingyi.core.optics.Lens;
import one.xingyi.core.optics.Setter;
import one.xingyi.json.JsonResourceList1;
import org.json.JSONArray;
import org.json.JSONObject;

public class Json
implements JsonParserAndWriter<Object> {
    public static Json simple = new Json();

    public Object makeObject(Object ... namesAndValues) {
        JSONObject result = new JSONObject();
        for (int i = 0; i < namesAndValues.length; i += 2) {
            result.put((String)namesAndValues[i + 0], namesAndValues[i + 1]);
        }
        return result;
    }

    public <T> Object makeList(IResourceList<T> items) {
        return items.toList();
    }

    public Object liftString(String string) {
        return new JSONObject(string);
    }

    public String fromJ(Object o) {
        return o.toString();
    }

    public Object parse(String jsonString) {
        return new JSONObject(jsonString);
    }

    public String asString(Object o) {
        return o.toString();
    }

    public int asInt(Object o) {
        return (Integer)o;
    }

    public Object child(Object o, String name) {
        if (o instanceof Map) {
            return ((Map)o).get(name);
        }
        return ((JSONObject)o).get(name);
    }

    public List<Object> asList(Object o) {
        return ((JSONArray)o).toList();
    }

    public IResourceList<Object> asResourceList(Object o) {
        return new JsonResourceList1((JSONArray)o);
    }

    JSONObject copyOf(Object j) {
        return new JSONObject(new HashMap<String, Object>(((JSONObject)j).map));
    }

    public Lens<Object, Object> lensToChild(String childname) {
        Getter getter = j -> ((JSONObject)j).get(childname);
        Setter setter = (j, t) -> this.copyOf(j).put(childname, t);
        return Lens.create((Getter)getter, (Setter)setter);
    }

    public Lens<Object, String> lensToString(String name) {
        Getter getter = j -> ((JSONObject)j).getString(name);
        Setter setter = (j, t) -> this.copyOf(j).put(name, t);
        return Lens.create((Getter)getter, (Setter)setter);
    }

    public Lens<Object, Double> lensToDouble(String name) {
        Getter getter = j -> ((JSONObject)j).getDouble(name);
        Setter setter = (j, t) -> this.copyOf(j).put(name, t);
        return Lens.create((Getter)getter, (Setter)setter);
    }

    public Lens<Object, Integer> lensToInteger(String name) {
        Getter getter = j -> ((JSONObject)j).getInt(name);
        Setter setter = (j, t) -> this.copyOf(j).put(name, t);
        return Lens.create((Getter)getter, (Setter)setter);
    }

    public Lens<Object, IResourceList<Object>> lensToResourceList(String name) {
        Getter getter = j -> this.asResourceList(j, name);
        Setter setter = (j, rl) -> this.copyOf(j).put(name, rl.toList());
        return Lens.create((Getter)getter, (Setter)setter);
    }
}

