/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.optics;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import one.xingyi.optics.IFold;
import one.xingyi.optics.ILens;
import one.xingyi.optics.IOptional;
import one.xingyi.optics.Traversal;

public interface ITraversal<Main, Child>
extends IFold<Main, Child> {
    public Main modify(Main var1, Function<Child, Child> var2);

    public static <Main, Child> ITraversal<Main, Child> of(Function<Main, Stream<Child>> allFn, BiFunction<Main, Function<Child, Child>, Main> modifyFn) {
        return new Traversal<Main, Child>(allFn, modifyFn);
    }

    public static <T> ITraversal<List<T>, T> listTraversal() {
        return new Traversal(Collection::stream, (list, fn) -> list.stream().map(fn).toList());
    }

    public static <Main, Child> ITraversal<Main, Child> fromListLens(ILens<Main, List<Child>> lens) {
        return new Traversal(main -> ((List)lens.get(main)).stream(), (main, fn) -> lens.set(main, ((List)lens.get(main)).stream().map(fn).toList()));
    }

    public static <Main, Child> ITraversal<Main, Child> fromCollectionLens(ILens<Main, Collection<Child>> lens) {
        return new Traversal(main -> ((Collection)lens.get(main)).stream(), (main, fn) -> lens.set(main, ((Collection)lens.get(main)).stream().map(fn).toList()));
    }

    public static <Main, Child> ITraversal<Main, Child> fromStreamLens(ILens<Main, Stream<Child>> lens) {
        return new Traversal(lens::get, (main, fn) -> lens.set(main, ((Stream)lens.get(main)).map(fn)));
    }

    public <GrandChild> ITraversal<Main, GrandChild> andThen(ITraversal<Child, GrandChild> var1);

    public <GrandChild> ITraversal<Main, GrandChild> chainTraversal(IOptional<Child, GrandChild> var1);

    @Override
    public ITraversal<Main, Child> filter(Predicate<Child> var1);

    public void forEach(Main var1, Consumer<Child> var2);
}

